/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.server;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.hamcrest.CoreMatchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.testspec.TestProxySpecification;
import org.nakedobjects.remoting.data.Data;
import org.nakedobjects.remoting.data.DummyIdentityData;
import org.nakedobjects.remoting.data.DummyObjectData;
import org.nakedobjects.remoting.data.DummyReferenceData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.data.common.ReferenceData;
import org.nakedobjects.remoting.exchange.ExecuteServerActionRequest;
import org.nakedobjects.remoting.exchange.ExecuteServerActionResponse;
import org.nakedobjects.remoting.facade.impl.ServerFacadeImpl;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.testsystem.TestProxyNakedObject;
import org.nakedobjects.runtime.testsystem.TestProxySession;
import org.nakedobjects.runtime.testsystem.TestProxySystem;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;

@RunWith(value=JMock.class)
public class ServerFacadeImpl_RemoteActionTest {
    private Mockery mockery = new JUnit4Mockery();
    private AuthenticationManager mockAuthenticationManager;
    private ObjectEncoderDecoder mockEncoder;
    private ServerFacadeImpl server;
    private TestProxySystem system;
    private NakedObject adapter;
    private Oid oid;
    private DummyIdentityData targetData;
    private ReferenceData[] parameterData;
    private NakedObjectAction mockAction;

    @Before
    public void setUp() throws Exception {
        BasicConfigurator.configure();
        LogManager.getRootLogger().setLevel(Level.OFF);
        this.mockAuthenticationManager = (AuthenticationManager)this.mockery.mock(AuthenticationManager.class);
        this.mockEncoder = (ObjectEncoderDecoder)this.mockery.mock(ObjectEncoderDecoder.class);
        this.server = new ServerFacadeImpl(this.mockAuthenticationManager);
        this.server.setEncoder(this.mockEncoder);
        this.server.init();
        this.system = new TestProxySystem();
        this.system.init();
        this.adapter = this.system.createPersistentTestObject();
        this.oid = this.adapter.getOid();
        this.targetData = new DummyIdentityData(this.oid, TestProxyNakedObject.class.getName(), (Version)new TestProxyVersion(1));
        this.parameterData = new ReferenceData[0];
        TestProxySpecification proxySpecification = (TestProxySpecification)this.adapter.getSpecification();
        this.mockAction = (NakedObjectAction)this.mockery.mock(NakedObjectAction.class);
        proxySpecification.setupAction(this.mockAction);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectAction)this.one(ServerFacadeImpl_RemoteActionTest.this.mockAction)).getId();
                this.will(1.returnValue((Object)"action"));
                ((NakedObjectAction)this.one(ServerFacadeImpl_RemoteActionTest.this.mockAction)).execute((NakedObject)this.with(CoreMatchers.equalTo((Object)ServerFacadeImpl_RemoteActionTest.this.adapter)), (NakedObject[])this.with(CoreMatchers.equalTo((Object)new NakedObject[0])));
                this.will(1.returnValue((Object)ServerFacadeImpl_RemoteActionTest.this.adapter));
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        this.system.shutdown();
    }

    @Test
    public void testExecuteOK() {
        final ExecuteServerActionResponse results = null;
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectEncoderDecoder)this.one(ServerFacadeImpl_RemoteActionTest.this.mockEncoder)).encodeServerActionResult((NakedObject)this.with(CoreMatchers.equalTo((Object)ServerFacadeImpl_RemoteActionTest.this.adapter)), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])), (ReferenceData[])this.with(CoreMatchers.equalTo((Object)new ReferenceData[0])), (ObjectData)this.with(CoreMatchers.nullValue(ObjectData.class)), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])), (String[])this.with(CoreMatchers.equalTo((Object)new String[0])), (String[])this.with(CoreMatchers.equalTo((Object)new String[0])));
                this.will(2.returnValue((Object)results));
            }
        });
        NakedObjectsContext.getTransactionManager().startTransaction();
        ExecuteServerActionRequest request = new ExecuteServerActionRequest((AuthenticationSession)new TestProxySession(), NakedObjectActionConstants.USER, "action()", (ReferenceData)this.targetData, (Data[])this.parameterData);
        ExecuteServerActionResponse result = this.server.executeServerAction(request);
        NakedObjectsContext.getTransactionManager().endTransaction();
        Assert.assertEquals(results, (Object)result);
    }

    @Test
    public void testExecuteWhereObjectDeleted() {
        Object results = null;
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                DummyReferenceData deletedObjectIdentityData = new DummyReferenceData(ServerFacadeImpl_RemoteActionTest.this.adapter.getOid(), "", ServerFacadeImpl_RemoteActionTest.this.adapter.getVersion());
                ((ObjectEncoderDecoder)this.one(ServerFacadeImpl_RemoteActionTest.this.mockEncoder)).encodeIdentityData(ServerFacadeImpl_RemoteActionTest.this.adapter);
                this.will(3.returnValue((Object)deletedObjectIdentityData));
                ((ObjectEncoderDecoder)this.one(ServerFacadeImpl_RemoteActionTest.this.mockEncoder)).encodeServerActionResult((NakedObject)this.with(CoreMatchers.equalTo((Object)ServerFacadeImpl_RemoteActionTest.this.adapter)), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])), (ReferenceData[])this.with(CoreMatchers.equalTo((Object)new ReferenceData[]{deletedObjectIdentityData})), (ObjectData)this.with(CoreMatchers.nullValue(ObjectData.class)), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])), (String[])this.with(CoreMatchers.equalTo((Object)new String[0])), (String[])this.with(CoreMatchers.equalTo((Object)new String[0])));
                this.will(3.returnValue(null));
            }
        });
        NakedObjectsContext.getTransactionManager().startTransaction();
        NakedObjectsContext.getUpdateNotifier().addDisposedObject(this.adapter);
        ExecuteServerActionRequest request = new ExecuteServerActionRequest((AuthenticationSession)new TestProxySession(), NakedObjectActionConstants.USER, "action()", (ReferenceData)this.targetData, (Data[])this.parameterData);
        ExecuteServerActionResponse result = this.server.executeServerAction(request);
        NakedObjectsContext.getTransactionManager().endTransaction();
        Assert.assertEquals(results, (Object)result);
    }

    @Test
    public void testExecuteWhereObjectChanged() {
        Object results = null;
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                DummyObjectData changedObjectData = new DummyObjectData();
                ((ObjectEncoderDecoder)this.one(ServerFacadeImpl_RemoteActionTest.this.mockEncoder)).encodeForUpdate(ServerFacadeImpl_RemoteActionTest.this.adapter);
                this.will(4.returnValue((Object)changedObjectData));
                ((ObjectEncoderDecoder)this.one(ServerFacadeImpl_RemoteActionTest.this.mockEncoder)).encodeServerActionResult((NakedObject)this.with(CoreMatchers.equalTo((Object)ServerFacadeImpl_RemoteActionTest.this.adapter)), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[]{changedObjectData})), (ReferenceData[])this.with(CoreMatchers.equalTo((Object)new ReferenceData[0])), (ObjectData)this.with(CoreMatchers.nullValue(ObjectData.class)), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])), (String[])this.with(CoreMatchers.equalTo((Object)new String[0])), (String[])this.with(CoreMatchers.equalTo((Object)new String[0])));
                this.will(4.returnValue(null));
            }
        });
        NakedObjectsContext.getTransactionManager().startTransaction();
        NakedObjectsContext.getUpdateNotifier().addChangedObject(this.adapter);
        ExecuteServerActionRequest request = new ExecuteServerActionRequest((AuthenticationSession)new TestProxySession(), NakedObjectActionConstants.USER, "action()", (ReferenceData)this.targetData, (Data[])this.parameterData);
        ExecuteServerActionResponse result = this.server.executeServerAction(request);
        NakedObjectsContext.getTransactionManager().endTransaction();
        Assert.assertEquals(results, (Object)result);
    }

    @Test
    public void testExecuteWhereMessagesAndWarningGenerated() {
        Object results = null;
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectEncoderDecoder)this.one(ServerFacadeImpl_RemoteActionTest.this.mockEncoder)).encodeServerActionResult((NakedObject)this.with(CoreMatchers.equalTo((Object)ServerFacadeImpl_RemoteActionTest.this.adapter)), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])), (ReferenceData[])this.with(CoreMatchers.equalTo((Object)new ReferenceData[0])), (ObjectData)this.with(CoreMatchers.nullValue(ObjectData.class)), (ObjectData[])this.with(CoreMatchers.equalTo((Object)new ObjectData[0])), (String[])this.with(CoreMatchers.equalTo((Object)new String[]{"message 1", "message 2"})), (String[])this.with(CoreMatchers.equalTo((Object)new String[]{"warning 1", "warning 2"})));
                this.will(5.returnValue(null));
            }
        });
        NakedObjectsContext.getTransactionManager().startTransaction();
        NakedObjectsContext.getMessageBroker().addMessage("message 1");
        NakedObjectsContext.getMessageBroker().addMessage("message 2");
        NakedObjectsContext.getMessageBroker().addWarning("warning 1");
        NakedObjectsContext.getMessageBroker().addWarning("warning 2");
        ExecuteServerActionRequest request = new ExecuteServerActionRequest((AuthenticationSession)new TestProxySession(), NakedObjectActionConstants.USER, "action()", (ReferenceData)this.targetData, (Data[])this.parameterData);
        ExecuteServerActionResponse result = this.server.executeServerAction(request);
        NakedObjectsContext.getTransactionManager().endTransaction();
        Assert.assertEquals(results, (Object)result);
    }
}

