/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.remoting.client.ClientConnectionDefault;
import org.nakedobjects.remoting.client.authentication.AuthenticationManagerProxy;
import org.nakedobjects.remoting.client.authorization.AuthorizationManagerProxy;
import org.nakedobjects.remoting.client.facetdecorator.ProxyFacetDecorator;
import org.nakedobjects.remoting.client.persistence.ClientSideTransactionManager;
import org.nakedobjects.remoting.client.persistence.PersistenceSessionProxy;
import org.nakedobjects.remoting.client.persistence.ProxyPersistenceSessionFactory;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.facade.proxy.ServerFacadeProxy;
import org.nakedobjects.remoting.protocol.ClientMarshaller;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoderDefault;
import org.nakedobjects.remoting.transport.Transport;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authorization.AuthorizationManager;
import org.nakedobjects.runtime.persistence.PersistenceMechanismInstallerAbstract;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactoryDelegate;
import org.nakedobjects.runtime.persistence.PersistenceSessionTransactionManagement;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerProxy;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.remoting.ClientConnectionInstaller;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxyInstallerAbstract
extends PersistenceMechanismInstallerAbstract
implements ClientConnectionInstaller {
    private static final Logger LOG = Logger.getLogger(ProxyInstallerAbstract.class);
    private ObjectEncoderDecoder encoderDecoder;
    private ServerFacade serverFacade;

    public ProxyInstallerAbstract(String name) {
        super("connector", name);
    }

    protected ObjectEncoderDecoder getEncoderDecoder() {
        if (this.encoderDecoder == null) {
            this.encoderDecoder = ObjectEncoderDecoderDefault.create(this.getConfiguration());
        }
        return this.encoderDecoder;
    }

    private ServerFacade getServerFacade() {
        if (this.serverFacade == null) {
            this.serverFacade = this.createServerFacade();
            this.serverFacade.init();
        }
        return this.serverFacade;
    }

    protected ServerFacade createServerFacade() {
        Transport transport = this.createTransport();
        ClientMarshaller marshaller = this.createMarshaller(transport);
        ClientConnectionDefault connection = new ClientConnectionDefault(marshaller);
        return new ServerFacadeProxy(connection);
    }

    protected abstract Transport createTransport();

    protected abstract ClientMarshaller createMarshaller(Transport var1);

    public AuthenticationManager createAuthenticationManager() {
        return new AuthenticationManagerProxy(this.getConfiguration(), this.getServerFacade(), this.getEncoderDecoder());
    }

    public AuthorizationManager createAuthorizationManager() {
        return new AuthorizationManagerProxy(this.getConfiguration(), this.getServerFacade(), this.getEncoderDecoder());
    }

    public PersistenceSessionFactory createPersistenceSessionFactory(DeploymentType deploymentType) {
        return new ProxyPersistenceSessionFactory(deploymentType, (PersistenceSessionFactoryDelegate)this);
    }

    protected PersistenceSession createPersistenceSession(PersistenceSessionFactory persistenceSessionFactory, AdapterManagerExtended adapterManager, AdapterFactory adapterFactory, ObjectFactory objectFactory, OidGenerator oidGenerator, ServicesInjector servicesInjector) {
        PersistenceSessionProxy persistenceSession = new PersistenceSessionProxy(persistenceSessionFactory, adapterFactory, objectFactory, servicesInjector, oidGenerator, adapterManager, this.getServerFacade(), this.getEncoderDecoder());
        NakedObjectTransactionManager transactionManager = this.createTransactionManager(this.getConfiguration(), (AdapterManagerProxy)persistenceSession.getAdapterManager(), (PersistenceSessionTransactionManagement)persistenceSession);
        Ensure.ensureThatArg((Object)((Object)persistenceSession), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)transactionManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        transactionManager.injectInto((Object)persistenceSession);
        return persistenceSession;
    }

    protected NakedObjectTransactionManager createTransactionManager(NakedObjectConfiguration configuration, AdapterManagerProxy adapterManager, PersistenceSessionTransactionManagement transactionManagement) {
        return new ClientSideTransactionManager(adapterManager, transactionManagement, this.getServerFacade(), this.getEncoderDecoder());
    }

    public List<FacetDecorator> createDecorators() {
        return Arrays.asList(new FacetDecorator[]{new ProxyFacetDecorator(this.getConfiguration(), this.getServerFacade(), this.getEncoderDecoder())});
    }
}

