/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client.facets;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacetAbstract;
import org.nakedobjects.remoting.client.facets.ProxyUtil;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.exchange.SetAssociationRequest;
import org.nakedobjects.remoting.exchange.SetAssociationResponse;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionAddToFacetWrapProxy
extends CollectionAddToFacetAbstract
implements DecoratingFacet<CollectionAddToFacet> {
    private static final Logger LOG = Logger.getLogger(CollectionAddToFacetWrapProxy.class);
    private final ServerFacade serverFacade;
    private final ObjectEncoderDecoder encoderDecoder;
    private final CollectionAddToFacet underlyingFacet;
    private final String name;

    public CollectionAddToFacetWrapProxy(CollectionAddToFacet underlyingFacet, ServerFacade connection, ObjectEncoderDecoder encoderDecoder, String name) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
        this.serverFacade = connection;
        this.encoderDecoder = encoderDecoder;
        this.name = name;
    }

    public CollectionAddToFacet getDecoratedFacet() {
        return this.underlyingFacet;
    }

    public void add(NakedObject inObject, NakedObject referencedAdapter) {
        if (inObject.isPersistent()) {
            try {
                IdentityData targetReference = this.encoderDecoder.encodeIdentityData(inObject);
                IdentityData associateReference = this.encoderDecoder.encodeIdentityData(referencedAdapter);
                SetAssociationRequest request = new SetAssociationRequest(CollectionAddToFacetWrapProxy.getAuthenticationSession(), this.name, targetReference, associateReference);
                SetAssociationResponse response = this.serverFacade.setAssociation(request);
                ObjectData[] updates = response.getUpdates();
                this.encoderDecoder.decode(updates);
            }
            catch (ConcurrencyException e) {
                throw ProxyUtil.concurrencyException(e);
            }
            catch (NakedObjectException e) {
                LOG.error((Object)("remote exception: " + e.getMessage()), (Throwable)e);
                throw e;
            }
        } else {
            this.underlyingFacet.add(inObject, referencedAdapter);
        }
    }

    protected static AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }
}

