/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client.facets;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacetAbstract;
import org.nakedobjects.remoting.client.facets.ProxyUtil;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.exchange.ClearAssociationRequest;
import org.nakedobjects.remoting.exchange.ClearAssociationResponse;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionRemoveFromFacetWrapProxy
extends CollectionRemoveFromFacetAbstract
implements DecoratingFacet<CollectionRemoveFromFacet> {
    private static final Logger LOG = Logger.getLogger(CollectionRemoveFromFacetWrapProxy.class);
    private final ServerFacade serverFacade;
    private final ObjectEncoderDecoder encoder;
    private final CollectionRemoveFromFacet underlyingFacet;
    private final String name;

    public CollectionRemoveFromFacetWrapProxy(CollectionRemoveFromFacet underlyingFacet, ServerFacade connection, ObjectEncoderDecoder encoder, String name) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
        this.serverFacade = connection;
        this.encoder = encoder;
        this.name = name;
    }

    public CollectionRemoveFromFacet getDecoratedFacet() {
        return this.underlyingFacet;
    }

    public void remove(NakedObject inObject, NakedObject associate) {
        if (inObject.isPersistent()) {
            LOG.debug((Object)("clear association remotely " + inObject + "/" + associate));
            try {
                IdentityData targetReference = this.encoder.encodeIdentityData(inObject);
                IdentityData associateReference = this.encoder.encodeIdentityData(associate);
                ClearAssociationRequest request = new ClearAssociationRequest(CollectionRemoveFromFacetWrapProxy.getAuthenticationSession(), this.name, targetReference, associateReference);
                ClearAssociationResponse response = this.serverFacade.clearAssociation(request);
                ObjectData[] updates = response.getUpdates();
                this.encoder.decode(updates);
            }
            catch (ConcurrencyException e) {
                throw ProxyUtil.concurrencyException(e);
            }
            catch (NakedObjectException e) {
                LOG.error((Object)("remote exception: " + e.getMessage()), (Throwable)e);
                throw e;
            }
        } else {
            LOG.debug((Object)("clear association locally " + inObject + "/" + associate));
            this.underlyingFacet.remove(inObject, associate);
        }
    }

    protected static AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }
}

