/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client.facets;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyClearFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyClearFacetAbstract;
import org.nakedobjects.remoting.client.facets.ProxyUtil;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.exchange.ClearAssociationRequest;
import org.nakedobjects.remoting.exchange.ClearAssociationResponse;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyClearFacetWrapProxy
extends PropertyClearFacetAbstract
implements DecoratingFacet<PropertyClearFacet> {
    private final ServerFacade serverFacade;
    private final ObjectEncoderDecoder encoder;
    private final PropertyClearFacet underlyingFacet;
    private final String name;

    public PropertyClearFacetWrapProxy(PropertyClearFacet underlyingFacet, ServerFacade serverFacade, ObjectEncoderDecoder encoderDecoder, String name) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
        this.serverFacade = serverFacade;
        this.encoder = encoderDecoder;
        this.name = name;
    }

    public PropertyClearFacet getDecoratedFacet() {
        return this.underlyingFacet;
    }

    public void clearProperty(NakedObject inObject) {
        if (inObject.isPersistent()) {
            ObjectData[] updates;
            IdentityData targetReference = this.encoder.encodeIdentityData(inObject);
            try {
                IdentityData nullData = this.encoder.encodeIdentityData(null);
                ClearAssociationRequest request = new ClearAssociationRequest(PropertyClearFacetWrapProxy.getAuthenticationSession(), this.name, targetReference, nullData);
                ClearAssociationResponse response = this.serverFacade.clearAssociation(request);
                updates = response.getUpdates();
            }
            catch (ConcurrencyException e) {
                throw ProxyUtil.concurrencyException(e);
            }
            this.encoder.decode(updates);
        } else {
            this.underlyingFacet.clearProperty(inObject);
        }
    }

    protected static AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }
}

