/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.client.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.remoting.client.persistence.ClientSideTransactionManager;
import org.nakedobjects.remoting.data.Data;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.data.query.PersistenceQueryData;
import org.nakedobjects.remoting.exchange.FindInstancesRequest;
import org.nakedobjects.remoting.exchange.FindInstancesResponse;
import org.nakedobjects.remoting.exchange.GetObjectRequest;
import org.nakedobjects.remoting.exchange.GetObjectResponse;
import org.nakedobjects.remoting.exchange.HasInstancesRequest;
import org.nakedobjects.remoting.exchange.HasInstancesResponse;
import org.nakedobjects.remoting.exchange.OidForServiceRequest;
import org.nakedobjects.remoting.exchange.OidForServiceResponse;
import org.nakedobjects.remoting.exchange.ResolveFieldRequest;
import org.nakedobjects.remoting.exchange.ResolveFieldResponse;
import org.nakedobjects.remoting.exchange.ResolveObjectRequest;
import org.nakedobjects.remoting.exchange.ResolveObjectResponse;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSessionAbstract;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.persistence.query.PersistenceQueryBuiltIn;
import org.nakedobjects.runtime.transaction.TransactionalClosure;
import org.nakedobjects.runtime.transaction.TransactionalClosureAbstract;
import org.nakedobjects.runtime.transaction.TransactionalClosureWithReturn;
import org.nakedobjects.runtime.transaction.TransactionalClosureWithReturnAbstract;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

public class PersistenceSessionProxy
extends PersistenceSessionAbstract {
    static final Logger LOG = Logger.getLogger(PersistenceSessionProxy.class);
    private final ServerFacade serverFacade;
    private final ObjectEncoderDecoder encoderDecoder;
    private final Map<NakedObjectSpecification, NakedObject> cache = new HashMap<NakedObjectSpecification, NakedObject>();
    private HashMap<String, Oid> serviceOidByNameCache = new HashMap();

    public PersistenceSessionProxy(PersistenceSessionFactory persistenceSessionFactory, AdapterFactory adapterFactory, ObjectFactory objectFactory, ServicesInjector containerInjector, OidGenerator oidGenerator, AdapterManagerExtended adapterManager, ServerFacade serverFacade, ObjectEncoderDecoder encoder) {
        super(persistenceSessionFactory, adapterFactory, objectFactory, containerInjector, oidGenerator, adapterManager);
        this.serverFacade = serverFacade;
        this.encoderDecoder = encoder;
    }

    public void doOpen() {
        this.serverFacade.init();
    }

    public void doClose() {
        this.serverFacade.shutdown();
    }

    public boolean isFixturesInstalled() {
        return true;
    }

    public synchronized NakedObject loadObject(Oid oid, NakedObjectSpecification hintSpec) {
        NakedObject adapter = this.getAdapterManager().getAdapterFor(oid);
        if (adapter != null) {
            return adapter;
        }
        return this.loadObjectFromPersistenceLayer(oid, hintSpec);
    }

    private NakedObject loadObjectFromPersistenceLayer(final Oid oid, final NakedObjectSpecification specHint) {
        return (NakedObject)this.getTransactionManager().executeWithinTransaction((TransactionalClosureWithReturn)new TransactionalClosureWithReturnAbstract<NakedObject>(){

            public NakedObject execute() {
                GetObjectRequest request = new GetObjectRequest(null, oid, specHint.getFullName());
                GetObjectResponse response = PersistenceSessionProxy.this.serverFacade.getObject(request);
                ObjectData data = response.getObjectData();
                return PersistenceSessionProxy.this.encoderDecoder.decode(data);
            }
        });
    }

    public void reload(NakedObject object) {
        IdentityData identityData = this.encoderDecoder.encodeIdentityData(object);
        this.reloadFromPersistenceLayer(identityData);
    }

    private void reloadFromPersistenceLayer(final IdentityData identityData) {
        this.getTransactionManager().executeWithinTransaction((TransactionalClosure)new TransactionalClosureAbstract(){

            public void execute() {
                ResolveObjectRequest request = new ResolveObjectRequest(PersistenceSessionProxy.getAuthenticationSession(), identityData);
                ResolveObjectResponse response = PersistenceSessionProxy.this.serverFacade.resolveImmediately(request);
                ObjectData update = response.getObjectData();
                PersistenceSessionProxy.this.encoderDecoder.decode(update);
            }
        });
    }

    public synchronized void resolveImmediately(NakedObject adapter) {
        ResolveState resolveState = adapter.getResolveState();
        if (!resolveState.canChangeTo(ResolveState.RESOLVING)) {
            return;
        }
        Oid oid = adapter.getOid();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("resolve object (remotely from server)" + oid));
        }
        this.resolveImmediatelyFromPersistenceLayer(adapter);
    }

    private void resolveImmediatelyFromPersistenceLayer(NakedObject adapter) {
        final IdentityData adapterData = this.encoderDecoder.encodeIdentityData(adapter);
        this.getTransactionManager().executeWithinTransaction((TransactionalClosure)new TransactionalClosureAbstract(){

            public void execute() {
                ResolveObjectRequest request = new ResolveObjectRequest(PersistenceSessionProxy.getAuthenticationSession(), adapterData);
                ResolveObjectResponse response = PersistenceSessionProxy.this.serverFacade.resolveImmediately(request);
                ObjectData data = response.getObjectData();
                NakedObject decodedAdapter = PersistenceSessionProxy.this.encoderDecoder.decode(data);
            }
        });
    }

    public void resolveField(NakedObject adapter, NakedObjectAssociation field) {
        if (field.getSpecification().isCollectionOrIsAggregated()) {
            return;
        }
        NakedObject referenceAdapter = field.get(adapter);
        if (referenceAdapter != null && referenceAdapter.getResolveState().isResolved()) {
            return;
        }
        if (referenceAdapter == null || !referenceAdapter.isPersistent()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("resolveField on server: " + adapter + "/" + field.getId()));
        }
        this.resolveFieldFromPersistenceLayer(adapter, field);
    }

    private void resolveFieldFromPersistenceLayer(NakedObject adapter, NakedObjectAssociation field) {
        final IdentityData adapterData = this.encoderDecoder.encodeIdentityData(adapter);
        final String fieldId = field.getId();
        this.getTransactionManager().executeWithinTransaction((TransactionalClosure)new TransactionalClosureAbstract(){

            public void execute() {
                ResolveFieldRequest request = new ResolveFieldRequest(PersistenceSessionProxy.getAuthenticationSession(), adapterData, fieldId);
                ResolveFieldResponse response = PersistenceSessionProxy.this.serverFacade.resolveField(request);
                Data data = response.getData();
                NakedObject decodedAdapter = PersistenceSessionProxy.this.encoderDecoder.decode(data);
            }
        });
    }

    public synchronized void makePersistent(NakedObject object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("makePersistent " + object));
        }
        this.makePersistentInPersistenceLayer(object);
    }

    protected void makePersistentInPersistenceLayer(final NakedObject object) {
        this.getTransactionManager().executeWithinTransaction((TransactionalClosure)new TransactionalClosureAbstract(){

            public void execute() {
                PersistenceSessionProxy.this.getTransactionManager().addMakePersistent(object);
            }
        });
    }

    public void objectChanged(NakedObject adapter) {
        if (adapter.isTransient()) {
            this.addObjectChangedToPresentationLayer(adapter);
            return;
        }
        if (adapter.getResolveState().respondToChangesInPersistentObjects()) {
            if (this.isImmutable(adapter)) {
                return;
            }
            this.addObjectChangedToPersistenceLayer(adapter);
        }
    }

    private void addObjectChangedToPresentationLayer(NakedObject adapter) {
        PersistenceSessionProxy.getUpdateNotifier().addChangedObject(adapter);
    }

    private void addObjectChangedToPersistenceLayer(final NakedObject adapter) {
        this.getTransactionManager().executeWithinTransaction((TransactionalClosure)new TransactionalClosureAbstract(){

            public void execute() {
                PersistenceSessionProxy.this.getTransactionManager().addObjectChanged(adapter);
            }
        });
    }

    public synchronized void destroyObject(NakedObject object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("destroyObject " + object));
        }
        this.destroyObjectInPersistenceLayer(object);
    }

    protected void destroyObjectInPersistenceLayer(final NakedObject object) {
        this.getTransactionManager().executeWithinTransaction((TransactionalClosure)new TransactionalClosureAbstract(){

            public void execute() {
                PersistenceSessionProxy.this.getTransactionManager().addDestroyObject(object);
            }
        });
    }

    protected NakedObject[] getInstances(PersistenceQuery persistenceQuery) {
        NakedObjectSpecification noSpec = persistenceQuery.getSpecification();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getInstances of " + noSpec + " with " + persistenceQuery));
        }
        if (this.canSatisfyFromCache(persistenceQuery)) {
            return this.getInstancesFromCache(persistenceQuery);
        }
        return this.findInstancesFromPersistenceLayer(persistenceQuery);
    }

    private boolean canSatisfyFromCache(PersistenceQuery persistenceQuery) {
        NakedObjectSpecification noSpec = persistenceQuery.getSpecification();
        return this.cache.containsKey(noSpec) && persistenceQuery instanceof PersistenceQueryBuiltIn;
    }

    private NakedObject[] getInstancesFromCache(PersistenceQuery persistenceQuery) {
        NakedObjectSpecification noSpec = persistenceQuery.getSpecification();
        PersistenceQueryBuiltIn builtIn = (PersistenceQueryBuiltIn)persistenceQuery;
        NakedObject collection = this.cache.get(noSpec);
        if (!collection.getSpecification().isCollection()) {
            return new NakedObject[0];
        }
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        ArrayList<NakedObject> instances = new ArrayList<NakedObject>();
        for (NakedObject instance : facet.iterable(collection)) {
            if (!builtIn.matches(instance)) continue;
            instances.add(instance);
        }
        return instances.toArray(new NakedObject[instances.size()]);
    }

    private NakedObject[] findInstancesFromPersistenceLayer(PersistenceQuery persistenceQuery) {
        final PersistenceQueryData criteriaData = this.encoderDecoder.encodePersistenceQuery(persistenceQuery);
        return (NakedObject[])this.getTransactionManager().executeWithinTransaction((TransactionalClosureWithReturn)new TransactionalClosureWithReturnAbstract<NakedObject[]>(){

            public NakedObject[] execute() {
                FindInstancesRequest request = new FindInstancesRequest(PersistenceSessionProxy.getAuthenticationSession(), criteriaData);
                FindInstancesResponse response = PersistenceSessionProxy.this.serverFacade.findInstances(request);
                ObjectData[] instancesAsObjectData = response.getInstances();
                NakedObject[] instances = new NakedObject[instancesAsObjectData.length];
                for (int i = 0; i < instancesAsObjectData.length; ++i) {
                    instances[i] = PersistenceSessionProxy.this.encoderDecoder.decode(instancesAsObjectData[i]);
                }
                return instances;
            }

            public void onSuccess() {
                PersistenceSessionProxy.this.clearAllDirty();
            }
        });
    }

    public boolean hasInstances(NakedObjectSpecification specification) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hasInstances of " + specification));
        }
        if (this.cache.containsKey(specification)) {
            return this.hasInstancesFromCache(specification);
        }
        return this.hasInstancesFromPersistenceLayer(specification);
    }

    private boolean hasInstancesFromCache(NakedObjectSpecification specification) {
        NakedObject collection = this.cache.get(specification);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        if (facet == null) {
            return false;
        }
        return facet.size(collection) > 0;
    }

    private boolean hasInstancesFromPersistenceLayer(NakedObjectSpecification specification) {
        final String specFullName = specification.getFullName();
        return (Boolean)this.getTransactionManager().executeWithinTransaction((TransactionalClosureWithReturn)new TransactionalClosureWithReturnAbstract<Boolean>(){

            public Boolean execute() {
                HasInstancesRequest request = new HasInstancesRequest(PersistenceSessionProxy.getAuthenticationSession(), specFullName);
                HasInstancesResponse response = PersistenceSessionProxy.this.serverFacade.hasInstances(request);
                return response.hasInstances();
            }
        });
    }

    public Oid getOidForService(String name) {
        Oid oid = this.serviceOidByNameCache.get(name);
        if (oid == null) {
            oid = this.getOidForServiceFromPersistenceLayer(name);
            this.registerService(name, oid);
        }
        return oid;
    }

    private Oid getOidForServiceFromPersistenceLayer(String serviceId) {
        OidForServiceRequest request = new OidForServiceRequest(PersistenceSessionProxy.getAuthenticationSession(), serviceId);
        OidForServiceResponse response = this.serverFacade.oidForService(request);
        IdentityData data = response.getOidData();
        return data.getOid();
    }

    public void registerService(String name, Oid oid) {
        this.serviceOidByNameCache.put(name, oid);
    }

    public ClientSideTransactionManager getTransactionManager() {
        return (ClientSideTransactionManager)super.getTransactionManager();
    }

    public void debugData(DebugString debug) {
        super.debugData(debug);
        debug.appendln("Server Facade", (Object)this.serverFacade);
    }

    public String debugTitle() {
        return "Proxy Persistence Sessino";
    }

    private static AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }

    private static UpdateNotifier getUpdateNotifier() {
        return NakedObjectsContext.getUpdateNotifier();
    }
}

