/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.exchange;

import java.io.IOException;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.remoting.exchange.GetObjectResponse;
import org.nakedobjects.remoting.exchange.RequestAbstract;
import org.nakedobjects.remoting.facade.ServerFacade;

public class GetObjectRequest
extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final Oid oid;
    private final String specificationName;

    public GetObjectRequest(AuthenticationSession session, Oid oid, String specificationName) {
        super(session);
        this.oid = oid;
        this.specificationName = specificationName;
        this.initialized();
    }

    public GetObjectRequest(DataInputExtended input) throws IOException {
        super(input);
        this.oid = (Oid)input.readEncodable(Oid.class);
        this.specificationName = input.readUTF();
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeEncodable((Object)this.oid);
        output.writeUTF(this.specificationName);
    }

    private void initialized() {
    }

    public Oid getOid() {
        return this.oid;
    }

    public String getSpecificationName() {
        return this.specificationName;
    }

    public void execute(ServerFacade serverFacade) {
        GetObjectResponse response = serverFacade.getObject(this);
        this.setResponse(response);
    }

    public GetObjectResponse getResponse() {
        return (GetObjectResponse)super.getResponse();
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("oid", (Object)this.oid);
        str.append("spec", this.specificationName);
        return str.toString();
    }
}

