/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.exchange;

import java.io.IOException;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.remoting.exchange.HasInstancesResponse;
import org.nakedobjects.remoting.exchange.RequestAbstract;
import org.nakedobjects.remoting.facade.ServerFacade;

public class HasInstancesRequest
extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String specificationName;

    public HasInstancesRequest(AuthenticationSession session, String specificationName) {
        super(session);
        this.specificationName = specificationName;
        this.initialized();
    }

    public HasInstancesRequest(DataInputExtended input) throws IOException {
        super(input);
        this.specificationName = input.readUTF();
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeUTF(this.specificationName);
    }

    private void initialized() {
    }

    public String getSpecificationName() {
        return this.specificationName;
    }

    public void execute(ServerFacade serverFacade) {
        HasInstancesResponse response = serverFacade.hasInstances(this);
        this.setResponse(response);
    }

    public HasInstancesResponse getResponse() {
        return (HasInstancesResponse)super.getResponse();
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("class", this.specificationName);
        return str.toString();
    }
}

