/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.exchange;

import java.io.IOException;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.remoting.exchange.OpenSessionResponse;
import org.nakedobjects.remoting.exchange.RequestAbstract;
import org.nakedobjects.remoting.facade.ServerFacade;

public class OpenSessionRequest
extends RequestAbstract {
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String password;

    public OpenSessionRequest(String username, String password) {
        super((AuthenticationSession)null);
        this.username = username;
        this.password = password;
        this.initialized();
    }

    public OpenSessionRequest(DataInputExtended input) throws IOException {
        super(input);
        this.username = input.readUTF();
        this.password = input.readUTF();
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeUTF(this.username);
        output.writeUTF(this.password);
    }

    private void initialized() {
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void execute(ServerFacade serverFacade) {
        OpenSessionResponse response = serverFacade.openSession(this);
        this.setResponse(response);
    }

    public OpenSessionResponse getResponse() {
        return (OpenSessionResponse)super.getResponse();
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("sequence", this.getId());
        return str.toString();
    }
}

