/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.facade;

import java.util.Properties;
import java.util.Vector;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.logging.Logger;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.remoting.data.Data;
import org.nakedobjects.remoting.data.common.CollectionData;
import org.nakedobjects.remoting.data.common.EncodableObjectData;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.NullData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.data.common.ReferenceData;
import org.nakedobjects.remoting.data.query.PersistenceQueryData;
import org.nakedobjects.remoting.exchange.AuthorizationRequestUsability;
import org.nakedobjects.remoting.exchange.AuthorizationRequestVisibility;
import org.nakedobjects.remoting.exchange.AuthorizationResponse;
import org.nakedobjects.remoting.exchange.ClearAssociationRequest;
import org.nakedobjects.remoting.exchange.ClearAssociationResponse;
import org.nakedobjects.remoting.exchange.ClearValueRequest;
import org.nakedobjects.remoting.exchange.ClearValueResponse;
import org.nakedobjects.remoting.exchange.CloseSessionRequest;
import org.nakedobjects.remoting.exchange.CloseSessionResponse;
import org.nakedobjects.remoting.exchange.ExecuteClientActionRequest;
import org.nakedobjects.remoting.exchange.ExecuteClientActionResponse;
import org.nakedobjects.remoting.exchange.ExecuteServerActionRequest;
import org.nakedobjects.remoting.exchange.ExecuteServerActionResponse;
import org.nakedobjects.remoting.exchange.FindInstancesRequest;
import org.nakedobjects.remoting.exchange.FindInstancesResponse;
import org.nakedobjects.remoting.exchange.GetObjectRequest;
import org.nakedobjects.remoting.exchange.GetObjectResponse;
import org.nakedobjects.remoting.exchange.GetPropertiesRequest;
import org.nakedobjects.remoting.exchange.GetPropertiesResponse;
import org.nakedobjects.remoting.exchange.HasInstancesRequest;
import org.nakedobjects.remoting.exchange.HasInstancesResponse;
import org.nakedobjects.remoting.exchange.OidForServiceRequest;
import org.nakedobjects.remoting.exchange.OidForServiceResponse;
import org.nakedobjects.remoting.exchange.OpenSessionRequest;
import org.nakedobjects.remoting.exchange.OpenSessionResponse;
import org.nakedobjects.remoting.exchange.ResolveFieldRequest;
import org.nakedobjects.remoting.exchange.ResolveFieldResponse;
import org.nakedobjects.remoting.exchange.ResolveObjectRequest;
import org.nakedobjects.remoting.exchange.ResolveObjectResponse;
import org.nakedobjects.remoting.exchange.SetAssociationRequest;
import org.nakedobjects.remoting.exchange.SetAssociationResponse;
import org.nakedobjects.remoting.exchange.SetValueRequest;
import org.nakedobjects.remoting.exchange.SetValueResponse;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class ServerFacadeLogger
extends Logger
implements ServerFacade {
    private static String PADDING = "      ";
    private final ObjectEncoderDecoder encoder;
    private final ServerFacade decorated;

    public ServerFacadeLogger(ObjectEncoderDecoder encoder, ServerFacade decorated, String fileName) {
        super(fileName, false);
        this.encoder = encoder;
        this.decorated = decorated;
    }

    public ServerFacadeLogger(ObjectEncoderDecoder encoder, ServerFacade decorated) {
        this(encoder, decorated, null);
    }

    protected Class getDecoratedClass() {
        return this.decorated.getClass();
    }

    public void init() {
        this.decorated.init();
    }

    public void shutdown() {
        this.decorated.shutdown();
    }

    public OpenSessionResponse openSession(OpenSessionRequest request) {
        this.log("authenticate");
        return this.decorated.openSession(request);
    }

    public AuthorizationResponse authorizeUsability(AuthorizationRequestUsability request) {
        this.log("authoriseUsability");
        return this.decorated.authorizeUsability(request);
    }

    public AuthorizationResponse authorizeVisibility(AuthorizationRequestVisibility request) {
        this.log("authoriseVisibility");
        return this.decorated.authorizeVisibility(request);
    }

    public CloseSessionResponse closeSession(CloseSessionRequest request) {
        AuthenticationSession session = request.getSession();
        this.log("close session " + session);
        CloseSessionResponse response = this.decorated.closeSession(request);
        return response;
    }

    public SetAssociationResponse setAssociation(SetAssociationRequest request) {
        AuthenticationSession session = request.getSession();
        String fieldIdentifier = request.getFieldIdentifier();
        IdentityData targetData = request.getTarget();
        IdentityData associateData = request.getAssociate();
        this.log("set association " + fieldIdentifier + this.indentedNewLine() + "target: " + this.dump(targetData) + this.indentedNewLine() + "associate: " + this.dump(associateData));
        SetAssociationResponse response = this.decorated.setAssociation(request);
        Data[] changes = response.getUpdates();
        this.log("  <-- changes: " + this.dump(changes));
        return response;
    }

    public SetValueResponse setValue(SetValueRequest request) {
        AuthenticationSession session = request.getSession();
        String fieldIdentifier = request.getFieldIdentifier();
        IdentityData target = request.getTarget();
        EncodableObjectData value = request.getValue();
        this.log("set value " + fieldIdentifier + this.indentedNewLine() + "target: " + this.dump(target) + this.indentedNewLine() + "value: " + value);
        SetValueResponse response = this.decorated.setValue(request);
        Data[] updates = response.getUpdates();
        this.log("  <-- changes: " + this.dump(updates));
        return response;
    }

    public ClearAssociationResponse clearAssociation(ClearAssociationRequest request) {
        String fieldIdentifier = request.getFieldIdentifier();
        IdentityData target = request.getTarget();
        IdentityData associate = request.getAssociate();
        this.log("clear association " + fieldIdentifier + this.indentedNewLine() + "target: " + this.dump(target) + this.indentedNewLine() + "associate: " + this.dump(associate));
        ClearAssociationResponse response = this.decorated.clearAssociation(request);
        Data[] updates = response.getUpdates();
        this.log("  <-- changes: " + this.dump(updates));
        return response;
    }

    public ClearValueResponse clearValue(ClearValueRequest request) {
        AuthenticationSession session = request.getSession();
        String fieldIdentifier = request.getFieldIdentifier();
        IdentityData target = request.getTarget();
        this.log("clear value " + fieldIdentifier + this.indentedNewLine() + "target: " + this.dump(target));
        ClearValueResponse response = this.decorated.clearValue(request);
        Data[] updates = response.getUpdates();
        this.log("  <-- changes: " + this.dump(updates));
        return response;
    }

    public ExecuteServerActionResponse executeServerAction(ExecuteServerActionRequest request) {
        ExecuteServerActionResponse result;
        AuthenticationSession session = request.getSession();
        NakedObjectActionType actionType = request.getActionType();
        String actionIdentifier = request.getActionIdentifier();
        ReferenceData target = request.getTarget();
        Data[] parameters = request.getParameters();
        this.log("execute action " + actionIdentifier + "/" + actionType + this.indentedNewLine() + "target: " + this.dump(target) + this.indentedNewLine() + "parameters: " + this.dump(parameters));
        try {
            result = this.decorated.executeServerAction(request);
            this.log("  <-- returns: " + this.dump(result.getReturn()));
            this.log("  <-- persisted target: " + this.dump(result.getPersistedTarget()));
            this.log("  <-- persisted parameters: " + this.dump(result.getPersistedParameters()));
            this.log("  <-- updates: " + this.dump(result.getUpdates()));
            this.log("  <-- disposed: " + this.dump(result.getDisposed()));
        }
        catch (RuntimeException e) {
            this.log("  <-- exception: " + e.getClass().getName() + " " + e.getMessage());
            throw e;
        }
        return result;
    }

    public ExecuteClientActionResponse executeClientAction(ExecuteClientActionRequest request) {
        AuthenticationSession session = request.getSession();
        ReferenceData[] data = request.getData();
        int[] types = request.getTypes();
        Vector complete = new Vector();
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            str.append(this.indentedNewLine());
            str.append("[");
            str.append(i + 1);
            str.append("] ");
            switch (types[i]) {
                case 1: {
                    str.append("persisted: ");
                    break;
                }
                case 2: {
                    str.append("changed: ");
                    break;
                }
                case 3: {
                    str.append("deleted: ");
                }
            }
            this.dump(str, data[i], 3, complete);
        }
        this.log("execute client action " + str);
        ExecuteClientActionResponse results = this.decorated.executeClientAction(request);
        complete = new Vector();
        str = new StringBuffer();
        ReferenceData[] persistedUpdates = results.getPersisted();
        Version[] changedVersions = results.getChanged();
        block10: for (int i = 0; i < persistedUpdates.length; ++i) {
            str.append(this.indentedNewLine());
            str.append("[");
            str.append(i + 1);
            str.append("] ");
            switch (types[i]) {
                case 1: {
                    str.append("persisted: ");
                    this.dump(str, persistedUpdates[i], 3, complete);
                    continue block10;
                }
                case 2: {
                    str.append("changed: ");
                    str.append(changedVersions[i]);
                }
            }
        }
        this.log(" <--- execute client action results" + str);
        return results;
    }

    public GetObjectResponse getObject(GetObjectRequest request) {
        AuthenticationSession session = request.getSession();
        Oid oid = request.getOid();
        String specificationName = request.getSpecificationName();
        this.log("get object " + oid);
        GetObjectResponse response = this.decorated.getObject(request);
        ObjectData data = response.getObjectData();
        this.log(" <-- data: " + data);
        return response;
    }

    public ResolveFieldResponse resolveField(ResolveFieldRequest request) {
        AuthenticationSession session = request.getSession();
        IdentityData target = request.getTarget();
        String fieldIdentifier = request.getFieldIdentifier();
        this.log("resolve field " + fieldIdentifier + " - " + this.dump(target));
        ResolveFieldResponse response = this.decorated.resolveField(request);
        Data result = response.getData();
        this.log(" <-- data: " + this.dump(result));
        return response;
    }

    public ResolveObjectResponse resolveImmediately(ResolveObjectRequest request) {
        AuthenticationSession session = request.getSession();
        IdentityData target = request.getTarget();
        this.log("resolve immediately" + this.dump(target));
        ResolveObjectResponse response = this.decorated.resolveImmediately(request);
        ObjectData objectData = response.getObjectData();
        this.log("  <-- data: " + this.dump(objectData));
        return response;
    }

    public FindInstancesResponse findInstances(FindInstancesRequest request) {
        AuthenticationSession session = request.getSession();
        PersistenceQueryData criteria = request.getCriteria();
        this.log("find instances " + criteria);
        FindInstancesResponse response = this.decorated.findInstances(request);
        Data[] instances = response.getInstances();
        this.log(" <-- instances: " + this.dump(instances));
        return response;
    }

    public HasInstancesResponse hasInstances(HasInstancesRequest request) {
        AuthenticationSession session = request.getSession();
        String specificationName = request.getSpecificationName();
        this.log("has instances " + specificationName);
        HasInstancesResponse response = this.decorated.hasInstances(request);
        boolean hasInstances = response.hasInstances();
        this.log(" <-- instances: " + (hasInstances ? "yes" : "no"));
        return response;
    }

    public GetPropertiesResponse getProperties(GetPropertiesRequest request) {
        this.log("get properties");
        GetPropertiesResponse response = this.decorated.getProperties(request);
        Properties properties = response.getProperties();
        this.log(" <-- data: " + properties);
        return response;
    }

    public OidForServiceResponse oidForService(OidForServiceRequest request) {
        AuthenticationSession session = request.getSession();
        String serviceId = request.getServiceId();
        this.log("oid for resource " + serviceId);
        OidForServiceResponse response = this.decorated.oidForService(request);
        IdentityData oidData = response.getOidData();
        this.log(" <-- data: " + this.dump(oidData));
        return response;
    }

    private String dump(Data data) {
        StringBuffer str = new StringBuffer();
        this.dump(str, data, 1, new Vector());
        return str.toString();
    }

    private String dump(Data[] data) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            str.append("\n    [");
            str.append(i + 1);
            str.append("] ");
            this.dump(str, data[i], 3, new Vector());
        }
        return str.toString();
    }

    private void dump(StringBuffer str, Data data, int indent, Vector complete) {
        if (data == null) {
            str.append("null");
        } else if (data instanceof NullData) {
            str.append("NULL (NullData object)");
        } else if (data instanceof EncodableObjectData) {
            EncodableObjectData encodeableObjectData = (EncodableObjectData)data;
            str.append("ValueData@" + Integer.toHexString(encodeableObjectData.hashCode()) + " " + encodeableObjectData.getType() + ":" + encodeableObjectData.getEncodedObjectData());
        } else if (data instanceof IdentityData) {
            IdentityData referenceData = (IdentityData)data;
            str.append("ReferenceData@" + Integer.toHexString(referenceData.hashCode()) + " " + referenceData.getType() + ":" + referenceData.getOid() + ":" + referenceData.getVersion());
        } else if (data instanceof ObjectData) {
            this.dumpObjectData(str, data, indent, complete);
        } else if (data instanceof CollectionData) {
            this.dumpCollectionData(str, data, indent, complete);
        } else {
            str.append("Unknown: " + data);
        }
    }

    private void dumpCollectionData(StringBuffer str, Data data, int indent, Vector complete) {
        CollectionData objectData = (CollectionData)data;
        str.append("CollectionData@" + Integer.toHexString(objectData.hashCode()) + " " + objectData.getType() + ":" + objectData.getOid() + ":" + (objectData.hasAllElements() ? "A" : "-") + ":" + objectData.getVersion());
        ReferenceData[] elements = objectData.getElements();
        for (int i = 0; elements != null && i < elements.length; ++i) {
            str.append("\n");
            str.append(this.padding(indent));
            str.append(i + 1);
            str.append(") ");
            this.dump(str, elements[i], indent + 1, complete);
        }
    }

    private void dumpObjectData(StringBuffer str, Data data, int indent, Vector complete) {
        ObjectData objectData = (ObjectData)data;
        str.append("ObjectData@" + Integer.toHexString(objectData.hashCode()) + " " + objectData.getType() + ":" + objectData.getOid() + ":" + (objectData.hasCompleteData() ? "C" : "-") + ":" + objectData.getVersion());
        if (complete.contains(objectData)) {
            str.append(" (already detailed)");
            return;
        }
        complete.addElement(objectData);
        NakedObjectSpecification spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(data.getType());
        NakedObjectAssociation[] fs = this.encoder.getFieldOrder(spec);
        Data[] fields = objectData.getFieldContent();
        for (int i = 0; fields != null && i < fields.length; ++i) {
            str.append("\n");
            str.append(this.padding(indent));
            str.append(i + 1);
            str.append(") ");
            str.append(fs[i].getId());
            str.append(": ");
            this.dump(str, fields[i], indent + 1, complete);
        }
    }

    private String indentedNewLine() {
        return "\n" + this.padding(2);
    }

    private String padding(int indent) {
        int length = indent * 3;
        while (length > PADDING.length()) {
            PADDING = PADDING + PADDING;
        }
        return PADDING.substring(0, length);
    }
}

