/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.protocol;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.remoting.protocol.ClientMarshaller;
import org.nakedobjects.remoting.protocol.ServerMarshaller;
import org.nakedobjects.remoting.transport.Transport;

public abstract class MarshallerAbstract
implements ClientMarshaller,
ServerMarshaller {
    private static final Logger LOG = Logger.getLogger(MarshallerAbstract.class);
    private final NakedObjectConfiguration configuration;
    private final Transport transport;
    private boolean keepAlive;

    public MarshallerAbstract(NakedObjectConfiguration configuration, Transport transport) {
        this.configuration = configuration;
        this.transport = transport;
    }

    public void init() {
        this.transport.init();
        this.keepAlive = this.getConfiguration().getBoolean("nakedobjects.protocol.keepalive", false);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("keepAlive=" + this.keepAlive));
        }
    }

    public void shutdown() {
        this.transport.disconnect();
        this.transport.shutdown();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void connect() throws IOException {
        this.transport.connect();
    }

    public void disconnect() {
        this.transport.disconnect();
    }

    protected void reconnect() throws IOException {
        this.disconnect();
        this.connect();
    }

    public NakedObjectConfiguration getConfiguration() {
        return this.configuration;
    }

    public Transport getTransport() {
        return this.transport;
    }
}

