/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.protocol.encoding.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.remoting.NakedObjectsRemoteException;
import org.nakedobjects.remoting.data.Data;
import org.nakedobjects.remoting.data.DataFactory;
import org.nakedobjects.remoting.data.DataFactoryDefault;
import org.nakedobjects.remoting.data.common.CollectionData;
import org.nakedobjects.remoting.data.common.EncodableObjectData;
import org.nakedobjects.remoting.data.common.IdentityData;
import org.nakedobjects.remoting.data.common.NullData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.data.common.ReferenceData;
import org.nakedobjects.remoting.data.query.PersistenceQueryData;
import org.nakedobjects.remoting.exchange.AuthorizationResponse;
import org.nakedobjects.remoting.exchange.ExecuteClientActionResponse;
import org.nakedobjects.remoting.exchange.ExecuteServerActionResponse;
import org.nakedobjects.remoting.exchange.KnownObjectsRequest;
import org.nakedobjects.remoting.protocol.encoding.internal.FieldOrderCache;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectDeserializer;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectSerializer;
import org.nakedobjects.remoting.protocol.encoding.internal.PersistenceQueryEncoder;
import org.nakedobjects.remoting.protocol.encoding.internal.PersistenceQueryFindAllInstancesEncoder;
import org.nakedobjects.remoting.protocol.encoding.internal.PersistenceQueryFindByPatternEncoder;
import org.nakedobjects.remoting.protocol.encoding.internal.PersistenceQueryFindByTitleEncoder;
import org.nakedobjects.remoting.protocol.encoding.internal.PersistenceQueryFindUsingApplibQueryDefaultEncoder;
import org.nakedobjects.remoting.protocol.encoding.internal.PersistenceQueryFindUsingApplibQuerySerializableEncoder;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistorUtil;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectEncoderDecoderDefault
implements ObjectEncoderDecoder {
    private static final Logger LOG = Logger.getLogger(ObjectEncoderDecoderDefault.class);
    public static final int DEFAULT_CLIENT_SIDE_ADD_OBJECT_GRAPH_DEPTH = 1;
    public static final int DEFAULT_CLIENT_SIDE_UPDATE_OBJECT_GRAPH_DEPTH = 1;
    public static final int DEFAULT_CLIENT_SIDE_ACTION_TARGET_GRAPH_DEPTH = 0;
    public static final int DEFAULT_CLIENT_SIDE_ACTION_PARAMETER_GRAPH_DEPTH = 0;
    public static final int DEFAULT_SERVER_SIDE_RETRIEVED_OBJECT_GRAPH_DEPTH = 100;
    public static final int DEFAULT_SERVER_SIDE_TOUCHED_OBJECT_GRAPH_DEPTH = 1;
    private final ObjectSerializer serializer;
    private final ObjectDeserializer deserializer;
    private final FieldOrderCache fieldOrderCache;
    private final DataFactory dataFactory;
    private final Map<Class<?>, PersistenceQueryEncoder> persistenceEncoderByClass = new HashMap();
    private int clientSideAddGraphDepth = 1;
    private int clientSideUpdateGraphDepth = 1;
    private int clientSideActionTargetRemotelyGraphDepth = 0;
    private int clientSideActionParameterGraphDepth = 0;
    private int serverSideTouchedObjectGraphDepth = 1;
    private int serverSideRetrievedObjectGraphDepth = 100;

    public static ObjectEncoderDecoderDefault create(NakedObjectConfiguration configuration) {
        ObjectEncoderDecoderDefault encoderDecoder = new ObjectEncoderDecoderDefault();
        ObjectEncoderDecoderDefault.addPersistenceEncoders(configuration, encoderDecoder, "nakedobjects.persistence-query.encoders");
        ObjectEncoderDecoderDefault.addPersistenceEncoders(configuration, encoderDecoder, "nakedobjects.criteria.encoders");
        return encoderDecoder;
    }

    private static void addPersistenceEncoders(NakedObjectConfiguration configuration, ObjectEncoderDecoderDefault encoder, String encoderClassNameList) {
        String[] encoders = configuration.getList(encoderClassNameList);
        for (int i = 0; i < encoders.length; ++i) {
            PersistenceQueryEncoder encoding = (PersistenceQueryEncoder)InstanceFactory.createInstance((String)encoders[i], PersistenceQueryEncoder.class);
            encoder.addPersistenceQueryEncoder(encoding);
        }
    }

    public ObjectEncoderDecoderDefault() {
        this.fieldOrderCache = new FieldOrderCache();
        this.dataFactory = new DataFactoryDefault();
        this.serializer = new ObjectSerializer(this.dataFactory, this.fieldOrderCache);
        this.deserializer = new ObjectDeserializer(this.fieldOrderCache);
        this.addPersistenceQueryEncoder(new PersistenceQueryFindAllInstancesEncoder());
        this.addPersistenceQueryEncoder(new PersistenceQueryFindByTitleEncoder());
        this.addPersistenceQueryEncoder(new PersistenceQueryFindByPatternEncoder());
        this.addPersistenceQueryEncoder(new PersistenceQueryFindUsingApplibQueryDefaultEncoder());
        this.addPersistenceQueryEncoder(new PersistenceQueryFindUsingApplibQuerySerializableEncoder());
    }

    public void addPersistenceQueryEncoder(PersistenceQueryEncoder encoder) {
        encoder.setObjectEncoder(this);
        this.persistenceEncoderByClass.put(encoder.getPersistenceQueryClass(), encoder);
    }

    @Override
    public final IdentityData encodeIdentityData(NakedObject object) {
        Assert.assertNotNull((String)"OID needed for reference", (Object)object, (Object)object.getOid());
        return this.dataFactory.createIdentityData(object.getSpecification().getFullName(), object.getOid(), object.getVersion());
    }

    @Override
    public ObjectData encodeMakePersistentGraph(NakedObject adapter, KnownObjectsRequest knownObjects) {
        Assert.assertTrue((String)"transient", (boolean)adapter.isTransient());
        return (ObjectData)this.encode(adapter, this.clientSideAddGraphDepth, knownObjects);
    }

    @Override
    public ObjectData encodeGraphForChangedObject(NakedObject object, KnownObjectsRequest knownObjects) {
        return (ObjectData)this.encode(object, this.clientSideUpdateGraphDepth, knownObjects);
    }

    @Override
    public EncodableObjectData encodeAsValue(NakedObject value) {
        return this.serializer.serializeEncodeable(value);
    }

    @Override
    public ReferenceData encodeActionTarget(NakedObject target, KnownObjectsRequest knownObjects) {
        return this.serializer.serializeAdapter(target, this.clientSideActionTargetRemotelyGraphDepth, knownObjects);
    }

    @Override
    public final Data[] encodeActionParameters(NakedObjectSpecification[] parameterTypes, NakedObject[] parameters, KnownObjectsRequest knownObjects) {
        Data[] parameterData = new Data[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            NakedObject parameter = parameters[i];
            String type = parameterTypes[i].getFullName();
            parameterData[i] = this.createParameter(type, parameter, knownObjects);
        }
        return parameterData;
    }

    @Override
    public PersistenceQueryData encodePersistenceQuery(PersistenceQuery criteria) {
        PersistenceQueryEncoder strategy = this.findPersistenceQueryEncoder(criteria.getClass());
        return strategy.encode(criteria);
    }

    @Override
    public void madePersistent(NakedObject target, ObjectData persistedTarget) {
        this.deserializer.madePersistent(target, persistedTarget);
    }

    @Override
    public NakedObject decode(Data data) {
        return this.deserializer.deserialize(data);
    }

    @Override
    public void decode(ObjectData[] dataArray) {
        for (int i = 0; i < dataArray.length; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("update " + dataArray[i].getOid()));
            }
            this.decode(dataArray[i]);
        }
    }

    @Override
    public NakedObject decode(Data data, KnownObjectsRequest knownObjects) {
        return this.deserializer.deserialize(data, knownObjects);
    }

    @Override
    public PersistenceQuery decodePersistenceQuery(PersistenceQueryData persistenceQueryData) {
        Class<?> criteriaClass = persistenceQueryData.getPersistenceQueryClass();
        PersistenceQueryEncoder encoderDecoder = this.findPersistenceQueryEncoder(criteriaClass);
        return encoderDecoder.decode(persistenceQueryData);
    }

    private PersistenceQueryEncoder findPersistenceQueryEncoder(Class<?> persistenceQueryClass) {
        PersistenceQueryEncoder encoder = this.persistenceEncoderByClass.get(persistenceQueryClass);
        if (encoder == null) {
            throw new NakedObjectsRemoteException("No encoder for " + persistenceQueryClass.getName());
        }
        return encoder;
    }

    @Override
    public AuthorizationResponse encodeAuthorizeResponse(boolean authorized) {
        return new AuthorizationResponse(authorized);
    }

    @Override
    public ExecuteClientActionResponse encodeClientActionResult(ReferenceData[] madePersistent, Version[] changedVersion, ObjectData[] updates) {
        return new ExecuteClientActionResponse(madePersistent, changedVersion, updates);
    }

    @Override
    public final ObjectData encodeCompletePersistentGraph(NakedObject object) {
        return this.encode(object, this.serverSideRetrievedObjectGraphDepth);
    }

    @Override
    public ObjectData encodeForUpdate(NakedObject object) {
        ResolveState resolveState = object.getResolveState();
        if (resolveState.isSerializing() || resolveState.isGhost()) {
            throw new NakedObjectsRemoteException("Illegal resolve state: " + object);
        }
        return this.encode(object, this.serverSideTouchedObjectGraphDepth);
    }

    @Override
    public Data encodeForResolveField(NakedObject adapter, String fieldName) {
        Oid oid = adapter.getOid();
        NakedObjectSpecification specification = adapter.getSpecification();
        String type = specification.getFullName();
        ResolveState resolveState = adapter.getResolveState();
        NakedObjectAssociation[] fields = this.getFieldOrder(specification);
        Data[] fieldContent = new Data[fields.length];
        PersistorUtil.start((NakedObject)adapter, (ResolveState)adapter.getResolveState().serializeFrom());
        KnownObjectsRequest knownObjects = new KnownObjectsRequest();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getId().equals(fieldName)) continue;
            NakedObject field = fields[i].get(adapter);
            if (field == null) {
                fieldContent[i] = this.dataFactory.createNullData(fields[i].getSpecification().getFullName());
                break;
            }
            if (fields[i].getSpecification().isEncodeable()) {
                fieldContent[i] = this.serializer.serializeEncodeable(field);
                break;
            }
            if (fields[i].isOneToManyAssociation()) {
                fieldContent[i] = this.serializer.serializeCollection(field, this.serverSideRetrievedObjectGraphDepth, knownObjects);
                break;
            }
            NakedObjectsContext.getPersistenceSession().resolveImmediately(field);
            fieldContent[i] = this.serializer.serializeAdapter(field, this.serverSideRetrievedObjectGraphDepth, knownObjects);
            break;
        }
        PersistorUtil.end((NakedObject)adapter);
        ObjectData data = this.dataFactory.createObjectData(type, oid, resolveState.isResolved(), adapter.getVersion());
        data.setFieldContent(fieldContent);
        return data;
    }

    @Override
    public ObjectData encodeMadePersistentGraph(ObjectData data, NakedObject object) {
        Oid objectsOid = object.getOid();
        Assert.assertNotNull((Object)objectsOid);
        if (objectsOid.hasPrevious()) {
            Version version = object.getVersion();
            String type = data.getType();
            ObjectData persistedData = this.dataFactory.createObjectData(type, objectsOid, true, version);
            Data[] allContents = data.getFieldContent();
            if (allContents != null) {
                int contentLength = allContents.length;
                Data[] persistentContents = new Data[contentLength];
                NakedObjectAssociation[] fields = this.getFieldOrder(object.getSpecification());
                for (int i = 0; i < contentLength; ++i) {
                    NakedObject fieldReference;
                    Data fieldData = allContents[i];
                    if (fieldData instanceof NullData) {
                        persistentContents[i] = null;
                        continue;
                    }
                    if (fields[i].isOneToOneAssociation()) {
                        if (fieldData instanceof ObjectData) {
                            fieldReference = fields[i].get(object);
                            persistentContents[i] = this.encodeMadePersistentGraph((ObjectData)fieldData, fieldReference);
                            continue;
                        }
                        persistentContents[i] = null;
                        continue;
                    }
                    if (!fields[i].isOneToManyAssociation()) continue;
                    fieldReference = fields[i].get(object);
                    persistentContents[i] = this.createMadePersistentCollection((CollectionData)fieldData, fieldReference);
                }
                persistedData.setFieldContent(persistentContents);
            }
            return persistedData;
        }
        return null;
    }

    private Data createMadePersistentCollection(CollectionData collectionData, NakedObject collection) {
        ReferenceData[] elementData = collectionData.getElements();
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        Iterator elements = facet.iterator(collection);
        for (int i = 0; i < elementData.length; ++i) {
            NakedObject element = (NakedObject)elements.next();
            Oid oid = element.getOid();
            Assert.assertNotNull((Object)oid);
            elementData[i] = this.encodeMadePersistentGraph((ObjectData)elementData[i], element);
        }
        return collectionData;
    }

    @Override
    public ExecuteServerActionResponse encodeServerActionResult(NakedObject result, ObjectData[] updatesData, ReferenceData[] disposedData, ObjectData persistedTargetData, ObjectData[] persistedParametersData, String[] messages, String[] warnings) {
        Data resultData;
        if (result == null) {
            resultData = this.dataFactory.createNullData("");
        } else if (result.getSpecification().isCollection()) {
            resultData = this.serializer.serializeCollection(result, this.serverSideRetrievedObjectGraphDepth, new KnownObjectsRequest());
        } else if (result.getSpecification().isObject()) {
            resultData = this.encodeCompletePersistentGraph(result);
        } else {
            throw new UnknownTypeException((Object)result);
        }
        return new ExecuteServerActionResponse(resultData, updatesData, disposedData, persistedTargetData, persistedParametersData, messages, warnings);
    }

    @Override
    public NakedObjectAssociation[] getFieldOrder(NakedObjectSpecification specification) {
        return this.fieldOrderCache.getFields(specification);
    }

    private final Data createParameter(String type, NakedObject adapter, KnownObjectsRequest knownObjects) {
        if (adapter == null) {
            return this.dataFactory.createNullData(type);
        }
        if (!adapter.getSpecification().isObject()) {
            throw new UnknownTypeException((Object)adapter.getSpecification());
        }
        if (adapter.getSpecification().isEncodeable()) {
            return this.serializer.serializeEncodeable(adapter);
        }
        return this.encode(adapter, this.clientSideActionParameterGraphDepth, knownObjects);
    }

    private ObjectData encode(NakedObject adapter, int depth) {
        return (ObjectData)this.encode(adapter, depth, new KnownObjectsRequest());
    }

    private ReferenceData encode(NakedObject adapter, int depth, KnownObjectsRequest knownObjects) {
        return this.serializer.serializeAdapter(adapter, depth, knownObjects);
    }
}

