/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.protocol.encoding.internal;

import java.util.Enumeration;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.remoting.data.Data;
import org.nakedobjects.remoting.data.DataFactory;
import org.nakedobjects.remoting.data.common.CollectionData;
import org.nakedobjects.remoting.data.common.EncodableObjectData;
import org.nakedobjects.remoting.data.common.ObjectData;
import org.nakedobjects.remoting.data.common.ReferenceData;
import org.nakedobjects.remoting.exchange.KnownObjectsRequest;
import org.nakedobjects.remoting.protocol.encoding.internal.FieldOrderCache;
import org.nakedobjects.runtime.persistence.PersistorUtil;

final class ObjectSerializer {
    private final DataFactory dataFactory;
    private final FieldOrderCache fieldOrderCache;

    public ObjectSerializer(DataFactory dataFactory, FieldOrderCache fieldOrderCache) {
        this.fieldOrderCache = fieldOrderCache;
        this.dataFactory = dataFactory;
    }

    public final ReferenceData serializeAdapter(NakedObject adapter, int depth, KnownObjectsRequest knownObjects) {
        Assert.assertNotNull((Object)adapter);
        return (ReferenceData)this.serializeObject2(adapter, depth, knownObjects);
    }

    public final EncodableObjectData serializeEncodeable(NakedObject adapter) {
        EncodableFacet facet = (EncodableFacet)adapter.getSpecification().getFacet(EncodableFacet.class);
        return this.dataFactory.createValueData(adapter.getSpecification().getFullName(), facet.toEncodedString(adapter));
    }

    private final Data serializeObject2(NakedObject adapter, int graphDepth, KnownObjectsRequest knownObjects) {
        Assert.assertNotNull((Object)adapter);
        ResolveState resolveState = adapter.getResolveState();
        boolean isTransient = adapter.isTransient();
        if (!isTransient && (resolveState.isSerializing() || resolveState.isGhost() || graphDepth <= 0)) {
            Assert.assertNotNull((String)"OID needed for reference", (Object)adapter, (Object)adapter.getOid());
            return this.dataFactory.createIdentityData(adapter.getSpecification().getFullName(), adapter.getOid(), adapter.getVersion());
        }
        if (isTransient && knownObjects.containsKey(adapter)) {
            return knownObjects.get(adapter);
        }
        boolean withCompleteData = resolveState == ResolveState.TRANSIENT || resolveState == ResolveState.RESOLVED;
        String type = adapter.getSpecification().getFullName();
        Oid oid = adapter.getOid();
        ObjectData data = this.dataFactory.createObjectData(type, oid, withCompleteData, adapter.getVersion());
        if (isTransient) {
            knownObjects.put(adapter, data);
        }
        NakedObjectAssociation[] fields = this.fieldOrderCache.getFields(adapter.getSpecification());
        Data[] fieldContent = new Data[fields.length];
        PersistorUtil.start((NakedObject)adapter, (ResolveState)adapter.getResolveState().serializeFrom());
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isNotDerived()) continue;
            NakedObject field = fields[i].get(adapter);
            if (fields[i].getSpecification().isEncodeable()) {
                if (field == null) {
                    fieldContent[i] = this.dataFactory.createNullData(fields[i].getSpecification().getFullName());
                    continue;
                }
                fieldContent[i] = this.serializeEncodeable(field);
                continue;
            }
            if (fields[i].isOneToManyAssociation()) {
                fieldContent[i] = this.serializeCollection(field, graphDepth - 1, knownObjects);
                continue;
            }
            if (fields[i].isOneToOneAssociation()) {
                if (field == null) {
                    fieldContent[i] = !withCompleteData ? null : this.dataFactory.createNullData(fields[i].getSpecification().getFullName());
                    continue;
                }
                fieldContent[i] = this.serializeObject2(field, graphDepth - 1, knownObjects);
                continue;
            }
            throw new UnknownTypeException((Object)fields[i]);
        }
        PersistorUtil.end((NakedObject)adapter);
        data.setFieldContent(fieldContent);
        return data;
    }

    public CollectionData serializeCollection(NakedObject collectionAdapter, int graphDepth, KnownObjectsRequest knownObjects) {
        ReferenceData[] elements;
        boolean hasAllElements;
        Oid oid = collectionAdapter.getOid();
        String collectionType = collectionAdapter.getSpecification().getFullName();
        TypeOfFacet typeOfFacet = (TypeOfFacet)collectionAdapter.getSpecification().getFacet(TypeOfFacet.class);
        if (typeOfFacet == null) {
            throw new NakedObjectException("No type of facet for collection " + collectionAdapter);
        }
        String elementType = typeOfFacet.value().getName();
        boolean bl = hasAllElements = collectionAdapter.isTransient() || collectionAdapter.getResolveState().isResolved();
        if (hasAllElements) {
            CollectionFacet collectionFacet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collectionAdapter);
            Enumeration e = collectionFacet.elements(collectionAdapter);
            elements = new ReferenceData[collectionFacet.size(collectionAdapter)];
            int i = 0;
            while (e.hasMoreElements()) {
                NakedObject element = (NakedObject)e.nextElement();
                elements[i++] = this.serializeAdapter(element, graphDepth, knownObjects);
            }
        } else {
            elements = new ObjectData[]{};
        }
        return this.dataFactory.createCollectionData(collectionType, elementType, oid, elements, hasAllElements, collectionAdapter.getVersion());
    }
}

