/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.remoting.exchange.OpenSessionRequest;
import org.nakedobjects.remoting.exchange.Request;
import org.nakedobjects.remoting.exchange.ResponseEnvelope;
import org.nakedobjects.remoting.server.ServerConnection;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.internal.monitor.Monitor;

public class ServerConnectionHandler {
    private static final Logger LOG = Logger.getLogger(ServerConnectionHandler.class);
    private static final Logger ACCESS_LOG = Logger.getLogger((String)"access_log");
    private final ServerConnection connection;
    private String debugRequest;
    private String debugAuthSession;
    private String debugResponse;
    private String debugContextId;
    private DebugInfo[] debugSessionInfo;
    private long responseTime;

    public ServerConnectionHandler(ServerConnection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest() throws IOException {
        long start = System.currentTimeMillis();
        Request request = this.connection.readRequest();
        AuthenticationSession authenticationSession = null;
        try {
            authenticationSession = this.openSessionIfNotAuthenticateRequest(request);
            this.monitorRequest(authenticationSession, request);
            this.executeRequest(request);
            this.sendResponse(request);
        }
        catch (Exception e) {
            this.sendExceptionResponse(e);
        }
        finally {
            this.closeSessionIfNotAuthenticateRequest(authenticationSession);
            this.calcResponseTime(start);
        }
    }

    private AuthenticationSession openSessionIfNotAuthenticateRequest(Request request) {
        AuthenticationSession authenticationSession;
        if (LOG.isDebugEnabled()) {
            this.debugRequest = request.getId() + " - " + request.toString();
        }
        if ((authenticationSession = request.getSession()) == null) {
            if (LOG.isDebugEnabled()) {
                this.debugAuthSession = "(none)";
                this.debugContextId = "(none)";
            }
            if (!(request instanceof OpenSessionRequest)) {
                throw new NakedObjectException("AuthenticationSession required for all requests (except the initial Authenticate request)");
            }
        } else {
            NakedObjectsContext.openSession((AuthenticationSession)authenticationSession);
            if (LOG.isDebugEnabled()) {
                this.debugAuthSession = authenticationSession.toString();
                this.debugContextId = NakedObjectsContext.getSessionId();
                this.debugSessionInfo = NakedObjectsContext.debugSession();
            }
        }
        return authenticationSession;
    }

    private void monitorRequest(AuthenticationSession authenticationSession, Request request) {
        String userName = authenticationSession != null ? authenticationSession.getUserName() : "**AUTHENTICATING**";
        String message = "{" + userName + "|" + this + "}  " + request.toString();
        ACCESS_LOG.info((Object)message);
        Monitor.addEvent((String)"REQUEST", (String)message, (DebugInfo[])this.debugSessionInfo);
    }

    private void executeRequest(Request request) {
        request.execute(this.connection.getServerFacade());
    }

    private void sendResponse(Request request) throws IOException {
        ResponseEnvelope response = new ResponseEnvelope(request);
        if (LOG.isDebugEnabled()) {
            this.debugResponse = response.toString();
            LOG.debug((Object)("sending " + this.debugResponse));
        }
        this.connection.sendResponse(response);
    }

    private void sendExceptionResponse(Exception e) throws IOException {
        LOG.error((Object)"error during remote request", (Throwable)e);
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        if (LOG.isDebugEnabled()) {
            this.debugResponse = sw.toString();
        }
        this.connection.sendResponse(e);
    }

    private void calcResponseTime(long start) {
        this.responseTime = System.currentTimeMillis() - start;
    }

    private void closeSessionIfNotAuthenticateRequest(AuthenticationSession authenticationSession) {
        if (authenticationSession == null) {
            return;
        }
        NakedObjectsContext.closeSession();
    }

    public void debug(DebugString debug) {
        debug.appendln("context Id", (Object)this.debugContextId);
        debug.appendln("authSession", (Object)this.debugAuthSession);
        debug.appendln("request", (Object)this.debugRequest);
        debug.appendln("response", (Object)this.debugResponse);
        debug.appendln("duration", (Object)((float)this.responseTime / 1000.0f + " secs."));
    }

    private void debugSessionInfo(DebugString debug) {
        try {
            if (this.debugSessionInfo != null) {
                for (DebugInfo info : this.debugSessionInfo) {
                    debug.appendTitle(info.debugTitle());
                    info.debugData(debug);
                }
            }
        }
        catch (RuntimeException e) {
            debug.appendException((Exception)e);
        }
    }
}

