/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.threads.ThreadRunner;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.facade.ServerFacadeLogger;
import org.nakedobjects.remoting.facade.impl.ServerFacadeImpl;
import org.nakedobjects.remoting.protocol.encoding.internal.ObjectEncoderDecoder;
import org.nakedobjects.remoting.server.ServerConnection;
import org.nakedobjects.remoting.transport.ConnectionException;
import org.nakedobjects.remoting.transport.ProfilingInputStream;
import org.nakedobjects.remoting.transport.ProfilingOutputStream;
import org.nakedobjects.remoting.transport.socket.server.Worker;
import org.nakedobjects.remoting.transport.socket.server.WorkerPool;
import org.nakedobjects.runtime.system.NakedObjectsSystem;
import org.nakedobjects.runtime.system.internal.monitor.HttpServerMonitor;
import org.nakedobjects.runtime.system.internal.monitor.SocketServerMonitor;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerAbstract;

public abstract class SocketsViewerAbstract
extends NakedObjectsViewerAbstract
implements DebugInfo {
    private static final Logger LOG = Logger.getLogger(SocketsViewerAbstract.class);
    final ObjectEncoderDecoder encoderDecoder;
    private ServerSocket socket;
    private WorkerPool workerPool;
    private Boolean shutdown = Boolean.FALSE;

    public SocketsViewerAbstract(ObjectEncoderDecoder encoderDecoder) {
        this.encoderDecoder = encoderDecoder;
    }

    public void init() {
        super.init();
        int port = SocketsViewerAbstract.getConfiguration().getInteger("nakedobjects.viewer.sockets.port", 9580);
        this.workerPool = new WorkerPool(5);
        ServerFacadeImpl serverFacade = new ServerFacadeImpl(SocketsViewerAbstract.getAuthenticationManager());
        serverFacade.setEncoder(this.encoderDecoder);
        ServerFacadeLogger sd = new ServerFacadeLogger(this.encoderDecoder, serverFacade);
        sd.init();
        this.socket = this.newServerSocket(port);
        LOG.info((Object)("listening for connection on " + this.socket));
        this.acceptAndHandleRequests(sd);
        this.shutdownListener();
    }

    private ServerSocket newServerSocket(int port) {
        try {
            ServerSocket socket = new ServerSocket(port);
            LOG.info((Object)("nof listener started on " + socket));
            socket.setSoTimeout(1000);
            ServerSocket serverSocket = socket;
            return serverSocket;
        }
        catch (IOException e) {
            throw new NakedObjectException((Throwable)e);
        }
        finally {
            this.shutdown(this.socket);
        }
    }

    private void acceptAndHandleRequests(ServerFacade sd) {
        while (!this.isShutdown()) {
            try {
                Socket clientSocket = this.socket.accept();
                LOG.info((Object)("connection accepted from " + clientSocket.getInetAddress()));
                InputStream inputStream = clientSocket.getInputStream();
                OutputStream outputStream = clientSocket.getOutputStream();
                if (this.isDebugging()) {
                    inputStream = new ProfilingInputStream(inputStream);
                    outputStream = new ProfilingOutputStream(outputStream);
                }
                ServerConnection connection = this.createServerConnection(inputStream, outputStream, sd);
                Worker worker = this.workerPool.getWorker();
                worker.setIncomingConnection(connection);
            }
            catch (InterruptedIOException ignore) {
            }
            catch (IOException e) {
                LOG.warn((Object)"connection exception", (Throwable)e);
            }
            catch (ConnectionException e) {
                LOG.warn((Object)"connection exception", (Throwable)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LOG.info((Object)"stopping listener");
        Boolean bl = this.shutdown;
        synchronized (bl) {
            this.shutdown = Boolean.TRUE;
        }
    }

    private void shutdownListener() {
        this.shutdown(this.socket);
        this.socket = null;
        this.shutdown(this.workerPool);
        this.workerPool = null;
    }

    private void shutdown(ServerSocket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
            LOG.info((Object)"socket closed");
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to close listening socket", (Throwable)e);
        }
    }

    private void shutdown(WorkerPool workerPool) {
        if (workerPool == null) {
            return;
        }
        workerPool.shutdown();
        LOG.info((Object)"worker pool stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isShutdown() {
        Boolean bl = this.shutdown;
        synchronized (bl) {
            return this.shutdown;
        }
    }

    protected abstract ServerConnection createServerConnection(InputStream var1, OutputStream var2, ServerFacade var3);

    public void debugData(DebugString debug) {
        debug.appendln("Listener on", (Object)this.socket.toString());
        debug.appendln("Workers", (Object)this.workerPool);
        this.workerPool.debug(debug);
    }

    public String debugTitle() {
        return "Server Listener";
    }

    private boolean isDebugging() {
        return true;
    }

    private void startMonitors(final NakedObjectsSystem system) {
        if (system.getDeploymentType().shouldMonitor()) {
            Runnable serverMonitorRunnable = new Runnable(){

                public void run() {
                    SocketServerMonitor serverMonitor = new SocketServerMonitor();
                    serverMonitor.setTarget(system);
                    serverMonitor.listen();
                }
            };
            new ThreadRunner().startThread(serverMonitorRunnable, "Monitor-1");
            Runnable httpServerMonitorRunnable = new Runnable(){

                public void run() {
                    HttpServerMonitor httpServerMonitor = new HttpServerMonitor();
                    httpServerMonitor.setTarget(system);
                    httpServerMonitor.listen();
                }
            };
            new ThreadRunner().startThread(httpServerMonitorRunnable, "Monitor-2");
        }
    }
}

