/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.transport.pipe;

import org.apache.log4j.Logger;
import org.nakedobjects.remoting.exchange.Request;
import org.nakedobjects.remoting.exchange.ResponseEnvelope;

public class PipedConnection {
    private static final Logger LOG = Logger.getLogger(PipedConnection.class);
    private Request request;
    private ResponseEnvelope response;
    private RuntimeException exception;

    public synchronized void setRequest(Request request) {
        this.request = request;
        this.notify();
    }

    public synchronized Request getRequest() {
        while (this.request == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                LOG.error((Object)"wait (getRequest) interrupted", (Throwable)e);
            }
        }
        Request r = this.request;
        this.request = null;
        this.notify();
        return r;
    }

    public synchronized void setResponse(ResponseEnvelope response) {
        this.response = response;
        this.notify();
    }

    public synchronized void setException(RuntimeException exception) {
        this.exception = exception;
        this.notify();
    }

    public synchronized ResponseEnvelope getResponse() {
        while (this.response == null && this.exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                LOG.error((Object)"wait (getResponse) interrupted", (Throwable)e);
            }
        }
        if (this.exception != null) {
            RuntimeException toThrow = this.exception;
            this.exception = null;
            throw toThrow;
        }
        ResponseEnvelope r = this.response;
        this.response = null;
        this.notify();
        return r;
    }
}

