/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.transport.pipe;

import org.apache.log4j.Logger;
import org.nakedobjects.remoting.exchange.Request;
import org.nakedobjects.remoting.exchange.ResponseEnvelope;
import org.nakedobjects.remoting.facade.ServerFacade;
import org.nakedobjects.remoting.transport.pipe.PipedConnection;

public class PipedServer {
    private static final Logger LOG = Logger.getLogger(PipedServer.class);
    private ServerFacade facade;
    private PipedConnection communication;

    public synchronized void run() {
        while (true) {
            Request request = this.communication.getRequest();
            LOG.debug((Object)("client request: " + request));
            try {
                request.execute(this.facade);
                ResponseEnvelope response = new ResponseEnvelope(request);
                LOG.debug((Object)("server response: " + response));
                this.communication.setResponse(response);
                continue;
            }
            catch (RuntimeException e) {
                this.communication.setException(e);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"failure during request", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setConnection(PipedConnection communication) {
        this.communication = communication;
    }

    public void setFacade(ServerFacade facade) {
        this.facade = facade;
    }
}

