/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.transport.socket.server;

import java.io.IOException;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.remoting.server.ServerConnection;
import org.nakedobjects.remoting.server.ServerConnectionHandler;
import org.nakedobjects.remoting.transport.socket.server.WorkerPool;

public class Worker
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Worker.class);
    private static int nextId = 1;
    private final WorkerPool poolToReturnTo;
    private final int id = nextId++;
    private boolean running = true;
    private ServerConnection connection;
    private ServerConnectionHandler serverDelegate;

    public Worker(WorkerPool pool) {
        this.poolToReturnTo = pool;
    }

    public synchronized void gracefulStop() {
        this.running = false;
    }

    public boolean isAvailable() {
        return this.connection == null;
    }

    public synchronized void run() {
        while (this.running) {
            this.waitForIncomingConnection();
            if (this.connection == null) break;
            this.handleRequest();
        }
        LOG.info((Object)("Stopping: " + this.toString()));
    }

    public synchronized void setIncomingConnection(ServerConnection connection) {
        this.connection = connection;
        this.serverDelegate = new ServerConnectionHandler(connection);
        this.notify();
    }

    private void waitForIncomingConnection() {
        while (this.connection == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (this.running) continue;
                LOG.info((Object)("Request to stop : " + this.toString()));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest() {
        try {
            this.serverDelegate.handleRequest();
        }
        catch (SocketException e) {
            LOG.info((Object)("shutting down receiver (" + e + ")"));
        }
        catch (IOException e) {
            LOG.info((Object)"connection exception; closing connection", (Throwable)e);
        }
        finally {
            this.end();
        }
    }

    private void end() {
        this.serverDelegate = null;
        this.connection = null;
        this.poolToReturnTo.returnWorker(this);
    }

    public void debug(DebugString debug) {
        this.serverDelegate.debug(debug);
    }

    public String toString() {
        return "Worker#" + this.id;
    }
}

