/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.remoting.transport.socket.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.remoting.transport.socket.server.Worker;

public class WorkerPool {
    private static final Logger LOG = Logger.getLogger(WorkerPool.class);
    private final ThreadGroup group;
    public Vector available = new Vector();
    public Vector all = new Vector();

    public WorkerPool(int noThreads) {
        this.addWorkers(noThreads);
        this.group = new ThreadGroup("worker");
    }

    public void shutdown() {
        this.gracefulShutdown();
    }

    private void interruptGroup() {
        Class<?> cls = this.group.getClass();
        try {
            Method interrupt = cls.getMethod("interrupt", null);
            interrupt.invoke((Object)this.group, (Object[])null);
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (IllegalAccessException e) {
            throw new NakedObjectException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new NakedObjectException(e.getMessage());
        }
        this.group.stop();
    }

    public synchronized void gracefulShutdown() {
        LOG.info((Object)"worker pool graceful shutdown");
        for (Worker worker : this.all) {
            worker.gracefulStop();
        }
        this.interruptGroup();
    }

    public synchronized void addWorkers(int noThreads) {
        for (int i = 0; i < noThreads; ++i) {
            Worker worker = new Worker(this);
            this.available.add(worker);
            this.all.add(worker);
            Thread t = new Thread(this.group, worker);
            t.start();
        }
        this.notify();
    }

    public synchronized Worker getWorker() {
        while (this.available.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        Worker worker = (Worker)this.available.elementAt(0);
        this.available.removeElementAt(0);
        LOG.debug((Object)("worker thread provided " + worker));
        return worker;
    }

    public synchronized void returnWorker(Worker worker) {
        if (this.available.contains(worker)) {
            throw new NakedObjectException("Worker thread has already been returned to queue");
        }
        LOG.debug((Object)("worker thread returned " + worker));
        this.available.addElement(worker);
        this.notify();
    }

    public void debug(DebugString debug) {
        debug.appendln("available", (Object)this.available);
        debug.appendln();
        debug.appendln();
        for (int i = 0; i < this.available.size(); ++i) {
            Worker worker = (Worker)this.available.elementAt(i);
            debug.appendln(i + 1 + ". " + worker.toString());
            debug.indent();
            worker.debug(debug);
            debug.unindent();
            debug.appendln();
        }
    }

    public String toString() {
        return "WorkerGroup[groupName=" + this.group.getName() + "]";
    }
}

