package org.nakedobjects.runtime.authentication.standard;

import java.io.Serializable;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.lang.ToString;


public final class SimpleSession implements AuthenticationSession, Encodable, Serializable {
    
    private static final long serialVersionUID = 1L;
    
    private final String name;
    private final String code;
    private final String[] roles;

    /**
     * Defaults {@link #getValidationCode()} to empty string (<tt>""</tt>).
     * 
     * @param name
     * @param roles
     */
    public SimpleSession(final String name, final String[] roles) {
        this(name, roles, "");
    }

    public SimpleSession(final String name, final String[] roles, final String code) {
        this.name = name;
        this.code = code;
        if (roles == null) {
            this.roles = new String[0];
        } else {
            this.roles = roles;
        }
    }

    public SimpleSession(final ByteDecoder decoder) {
        name = decoder.getString();
        code = decoder.getString();
        roles = decoder.getList();
    }

    public void open() {}

    public void close() {}
    

    public String getValidationCode() {
        return code;
    }

    public String getUserName() {
        return name;
    }

    public String[] getRoles() {
        return roles;
    }

    @Override
    public String toString() {
        final ToString str = new ToString(this);
        str.append("name", name);
        str.append("code", code);
        return str.toString();
    }

    public void encode(final ByteEncoder encoder) {
        encoder.add(name);
        encoder.add(code);
        encoder.add(roles);
    }

}
// Copyright (c) Naked Objects Group Ltd.
