package org.nakedobjects.runtime.authorization.standard;

import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.specloader.FacetDecoratorInstaller;
import org.nakedobjects.runtime.installers.InstallerAbstract;


public abstract class AuthorizationFacetDecoratorStandardInstallerAbstract extends InstallerAbstract implements FacetDecoratorInstaller {

    private final String name;
    
    public AuthorizationFacetDecoratorStandardInstallerAbstract(final String name) {
        this.name = name;
    }
    public FacetDecorator createDecorator() {
        final Authorizor authorisor = createAuthorisor(getConfiguration());
        return new AuthorizationFacetDecoratorStandard(authorisor);
    }

    protected abstract Authorizor createAuthorisor(final NakedObjectConfiguration configuration);
    
    public String getName() {
        return name;
    }

}

// Copyright (c) Naked Objects Group Ltd.
