package org.nakedobjects.runtime.boot.cmdline.internal;

import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.ADDITIONAL_PROPERTY;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.CONFIGURATION_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.CONFIGURATION_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.CONNECTION_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.CONNECTION_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.DEBUG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.DIAGNOSTICS_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.FIXTURE_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.FIXTURE_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.HELP_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.HELP_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.NO_SPLASH_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.NO_SPLASH_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.OBJECT_PERSISTENCE_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.OBJECT_PERSISTENCE_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.PASSWORD_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.PASSWORD_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.QUIET_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.REFLECTOR_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.REFLECTOR_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.TYPE_CLIENT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.TYPE_EXPLORATION;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.TYPE_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.TYPE_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.TYPE_PROTOTYPE;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.TYPE_SERVER;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.TYPE_SERVER_EXPLORATION;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.TYPE_SERVER_PROTOTYPE;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.TYPE_STANDALONE;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.USER_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.USER_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.USER_PROFILE_PERSISTENCE_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.USER_PROFILE_PERSISTENCE_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.VERBOSE_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.VERSION_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.VIEWER_LONG_OPT;
import static org.nakedobjects.runtime.boot.cmdline.internal.Arguments.VIEWER_OPT;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.nakedobjects.metamodel.commons.component.Installer;
import org.nakedobjects.metamodel.specloader.NakedObjectReflectorInstaller;
import org.nakedobjects.runtime.client.NakedObjectClientInstaller;
import org.nakedobjects.runtime.installers.InstallerRepository;
import org.nakedobjects.runtime.persistence.PersistenceMechanismInstaller;
import org.nakedobjects.runtime.remoting.ServerListenerInstaller;
import org.nakedobjects.runtime.userprofile.UserProfileStoreInstaller;


public class ArgumentsOptionsBuilder {



    private InstallerRepository installerRepository;

    public ArgumentsOptionsBuilder(InstallerRepository installerRepository) {
        this.installerRepository = installerRepository;
    }

    public void addBasicOptions(final Options options) {
        options.addOption(HELP_OPT, HELP_LONG_OPT, false, "show this help");
        options.addOption(NO_SPLASH_OPT, NO_SPLASH_LONG_OPT, false, "don't show splash window");
        options.addOption(DEBUG_OPT, false, "print debugging messages");
        options.addOption(VERBOSE_OPT, false, "print information, warning and error messages");
        options.addOption(QUIET_OPT, false, "print error messages only");
        options.addOption(DIAGNOSTICS_OPT, false, "print information that can be used diagnose or report problems");
        options.addOption(VERSION_OPT, false, "print version information");
    }

    @SuppressWarnings("static-access")
	public
    void addComponentOptions(Options options) {
        Option option = OptionBuilder.withArgName("config file").hasArg().withLongOpt(CONFIGURATION_LONG_OPT).withDescription(
                "read in configuration file (as well as nakedobjects.properties)").create(CONFIGURATION_OPT);
        options.addOption(option);
    
        option = OptionBuilder.withArgName("name").hasArg().withLongOpt(TYPE_LONG_OPT).withDescription(
                "type of system: " + TYPE_EXPLORATION + "; " + TYPE_PROTOTYPE + " (default); " + TYPE_STANDALONE + "; "
                        + TYPE_CLIENT + "; " + TYPE_SERVER_EXPLORATION + "; " + TYPE_SERVER_PROTOTYPE + "; " + TYPE_SERVER).create(TYPE_OPT);
        options.addOption(option);
    
        option = OptionBuilder.withArgName("user name").hasArg().withLongOpt(USER_LONG_OPT).withDescription(
                "user name to log in with").create(USER_OPT);
        options.addOption(option);
    
        option = OptionBuilder.withArgName("password").hasArg().withLongOpt(PASSWORD_LONG_OPT).withDescription(
                "password to automatically log in with").create(PASSWORD_OPT);
        options.addOption(option);
    
        option = OptionBuilder.withArgName("class name").hasArg().withLongOpt(FIXTURE_LONG_OPT).withDescription(
                "fully qualified fixture class").create(FIXTURE_OPT);
        options.addOption(option);
    
        Object[] objectPersistenceMechanisms = installerRepository.getInstallers(PersistenceMechanismInstaller.class);
        option = OptionBuilder.withArgName("name|class name").hasArg().withLongOpt(OBJECT_PERSISTENCE_LONG_OPT).withDescription(
                "object persistence mechanism to use (ignored if type is prototype or client): " + availableComponents(objectPersistenceMechanisms)
                        + "; or class name").create(OBJECT_PERSISTENCE_OPT);
        options.addOption(option);

        Object[] persistenceMechanisms = installerRepository.getInstallers(UserProfileStoreInstaller.class);
        option = OptionBuilder.withArgName("name|class name").hasArg().withLongOpt(USER_PROFILE_PERSISTENCE_LONG_OPT).withDescription(
                "user profile persistence mechanism to use: " + availableComponents(persistenceMechanisms)
                        + "; or class name").create(USER_PROFILE_PERSISTENCE_OPT);
        options.addOption(option);

        Object[] reflectors = installerRepository.getInstallers(NakedObjectReflectorInstaller.class);
        option = OptionBuilder.withArgName("name|class name").hasArg().withLongOpt(REFLECTOR_LONG_OPT).withDescription(
                "reflector to use (ignored if type is prototype or client): " + availableComponents(reflectors)
                        + "; or class name").create(REFLECTOR_OPT);
        options.addOption(option);
    
        Object[] viewers = installerRepository.getInstallers(NakedObjectClientInstaller.class);
        option = OptionBuilder.withArgName("name|class name").hasArg().withLongOpt(VIEWER_LONG_OPT).withDescription(
                "viewer to use (ignored if type is server): " + availableComponents(viewers) + "; or class name").create(
                VIEWER_OPT);
        options.addOption(option);
    
        Object[] connections = installerRepository.getInstallers(ServerListenerInstaller.class);
        option = OptionBuilder.withArgName("name|class name").hasArg().withLongOpt(CONNECTION_LONG_OPT).withDescription(
                "connection to use for client requests, or server to listen on: " + availableComponents(connections)).create(
                CONNECTION_OPT);
        options.addOption(option);
    
        Option property = OptionBuilder.withArgName("property=value").hasArg().withValueSeparator().withDescription(
                "use value for given property").create(ADDITIONAL_PROPERTY);
        property.setArgs(Option.UNLIMITED_VALUES);
        options.addOption(property);
    }

    StringBuffer availableComponents(final Object[] factories) {
        final StringBuffer types = new StringBuffer();
        for (int i = 0; i < factories.length; i++) {
            if (i > 0) {
                types.append("; ");
            }
            types.append(((Installer) factories[i]).getName());
        }
        return types;
    }


}
