package org.nakedobjects.runtime.boot.cmdline.internal;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Level;
import org.nakedobjects.runtime.system.DeploymentType;

public class ArgumentsParser {

    private BootPrinter printer;

    private CommandLine cmd;

    public ArgumentsParser(final BootPrinter printer) {
        this.printer = printer;
    }

    public static Level loggingLevel(final String[] args) {
        Level level = null;
        for (int i = 0; i < args.length; i++) {
            if (args[i].equals("-" + Arguments.DEBUG_OPT)) {
                level = Level.DEBUG;
                break;
            } else if (args[i].equals("-" + Arguments.QUIET_OPT)) {
                level = Level.ERROR;
                break;
            } else if (args[i].equals("-" + Arguments.VERBOSE_OPT)) {
                level = Level.INFO;
                break;
            }
        }
        return level;
    }

    public boolean parse(Options options, String[] args) {
        final CommandLineParser parser = new BasicParser();
        this.cmd = null;
        try {
            cmd = parser.parse(options, args);
        } catch (final ParseException e) {
            printer.printErrorMessage(e.getMessage());
            printer.printHelp(options);
            return false;
        }

        // help option
        if (cmd.hasOption(Arguments.HELP_OPT)) {
            printer.printHelp(options);
            return false;
        }

        if (cmd.hasOption(Arguments.VERSION_OPT)) {
            printer.printVersion();
            return false;
        }

        if (cmd.hasOption(Arguments.DIAGNOSTICS_OPT)) {
            printer.printDiagnostics();
            return false;
        }
        
        return true;
    }

    /**
     * Returns the {@link DeploymentType#name()}, but in lower case.
     */
    private String getDeploymentTypeName() {
        ensureParsed();
        String modeName = cmd.getOptionValue(Arguments.TYPE_OPT);
        return modeName == null ? Arguments.TYPE_PROTOTYPE : modeName.toLowerCase();
    }

    public DeploymentType getDeploymentType() {
        DeploymentType valueOf = DeploymentType.valueOf(getDeploymentTypeName().toUpperCase());
        if (valueOf != null) {
            return valueOf;
        }
        throw new IllegalStateException("Unable to determine deployment type");
    }


    public String getConnection() {
        return cmd.getOptionValue(Arguments.CONNECTION_OPT);
    }
    
    public String getProgModel() {
        return cmd.getOptionValue(Arguments.PROGMODEL_OPT);
    }

    
    public String getConfig() {
        return cmd.getOptionValue(Arguments.CONFIGURATION_OPT);
    }

    public String getObjectPersistor() {
        ensureParsed();
        return cmd.getOptionValue(Arguments.OBJECT_PERSISTENCE_OPT);
    }

    public String getUserProfilePersistor() {
        ensureParsed();
        return cmd.getOptionValue(Arguments.USER_PROFILE_PERSISTENCE_OPT);
    }

    public String getReflector() {
        ensureParsed();
        return cmd.getOptionValue(Arguments.REFLECTOR_OPT);
    }

    public String getUser() {
        ensureParsed();
        return cmd.getOptionValue(Arguments.USER_OPT);
    }

    public String getPassword() {
        ensureParsed();
        return cmd.getOptionValue(Arguments.PASSWORD_OPT);
    }

    public String getViewer() {
        ensureParsed();
        return cmd.getOptionValue(Arguments.VIEWER_OPT);
    }

    public String getFixture() {
        ensureParsed();
        return cmd.getOptionValue(Arguments.FIXTURE_OPT);
    }


    public boolean isSplash() {
        ensureParsed();
        boolean noSplash = cmd.hasOption('s');
        return !noSplash;
    }


    public String[] getAdditionalProperties() {
        ensureParsed();
        return cmd.getOptionValues(Arguments.ADDITIONAL_PROPERTY);
    }

    private void ensureParsed() {
        if (cmd == null) {
            throw new IllegalStateException("Call parse() first");
        }
    }

}
