package org.nakedobjects.runtime.boot.cmdline.internal;

import java.io.PrintStream;
import java.io.PrintWriter;

import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.nakedobjects.runtime.system.internal.monitor.SystemPrinter;


public class BootPrinter extends SystemPrinter {
    
    private PrintWriter printWriter;
    
    public BootPrinter(final PrintStream output) {
        super(output);
        this.printWriter = new PrintWriter(getOutput());
    }
    
    public BootPrinter() {
        this(System.out);
    }

    public void printErrorAndHelp(final Options options, final String formatStr, Object... args) {
        getOutput().println(String.format(formatStr, args));
        printHelp(options);
        printWriter.flush();
    }

    public void printHelp(final Options options) {
        final HelpFormatter help = new HelpFormatter();
        help.printHelp(printWriter, 80, "NakedObjects [options]", null, options, 0, 0, null, false);
        printWriter.flush();
    }


}
