package org.nakedobjects.runtime.boot.cmdline.internal;

import org.apache.commons.cli.Options;
import org.nakedobjects.metamodel.commons.lang.StringUtils;
import org.nakedobjects.runtime.system.DeploymentType;

public class CommandLineValidator {

    public boolean validateCommandLineArgs(
            final Options options,
            BootPrinter printer,
            final DeploymentType deploymentType,
            final String connection,
            final String objectPersistence,
            final String userProfilePersistence,
            final String user,
            final String password) {

        // check requested connection (if any)
        if (!StringUtils.isEmpty(connection) && !deploymentType.canSpecifyRemoting()) {
            printer.printErrorAndHelp(options, "Error: cannot specify a connection for '%s'\n", deploymentType.name()
                    .toLowerCase());
            return false;
        }

        // check requested object persistor (if any)
        if (objectPersistence != null && !deploymentType.canSpecifyObjectStore()) {
            printer.printErrorAndHelp(options, "Error: can't specify object store for '%s'\n", deploymentType.name()
                    .toLowerCase());
            return false;
        }

        // check user and password
        if (password != null && user == null) {
            printer.printErrorAndHelp(options, "A user name must be specified with a password");
        }

        return true;
    }

}


// Copyright (c) Naked Objects Group Ltd.
