package org.nakedobjects.runtime.boot.systemfactory.usinginstallers;

import org.apache.log4j.Level;
import org.nakedobjects.metamodel.config.loader.ConfigurationLoader;
import org.nakedobjects.runtime.boot.NakedObjectsBootstrapperAbstract;
import org.nakedobjects.runtime.boot.RootLogging;
import org.nakedobjects.runtime.boot.systemfactory.NakedObjectSystemFactory;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.installers.InstallerLookupImpl;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.NakedObjectsSystem;
import org.nakedobjects.runtime.system.Splash;
import org.nakedobjects.runtime.system.installers.NakedObjectsSystemUsingInstallers;


/**
 * Implementation of {@link NakedObjectSystemFactory} that uses {@link InstallerLookup} to convert the names
 * of components into actual component instances.
 */
public class NakedObjectSystemUsingInstallersFactory implements NakedObjectSystemFactory {

    private final InstallerLookupImpl installerLookup;

    
    ////////////////////////////////////////////////////////////
    // constructors
    ////////////////////////////////////////////////////////////

    public NakedObjectSystemUsingInstallersFactory() {
        this(NakedObjectsBootstrapperAbstract.class);
    }

    public NakedObjectSystemUsingInstallersFactory(final Class<?> lookupRelativeToClass) {
        this(new InstallerLookupImpl(lookupRelativeToClass));
    }

    public NakedObjectSystemUsingInstallersFactory(final InstallerLookupImpl installerLookup) {
        this.installerLookup = installerLookup;
    }

    
    public InstallerLookup getInstallerLookup() {
        return installerLookup;
    }

    
    ////////////////////////////////////////////////////////////
    // init, shutdown
    ////////////////////////////////////////////////////////////
    
	public void init() {
		installerLookup.loadInstallers();
	}

	public void shutdown() {
		// nothing to do
	}


    ////////////////////////////////////////////////////////////
    // main API
    ////////////////////////////////////////////////////////////

    public NakedObjectsSystem createSystem(
            final ConfigurationLoader configurationLoader,
            final Level loggingLevel,
            final DeploymentType deploymentType,
            final Splash splash) {

        installerLookup.setConfigurationLoader(configurationLoader);

        final NakedObjectsSystemUsingInstallers system = new NakedObjectsSystemUsingInstallers(deploymentType, installerLookup);
        if (loggingLevel != null) {
            RootLogging.setRootLoggingLevel(loggingLevel);
        }
        system.setHideSplash(!splash.isShow());

        system.lookupAndSetAuthenticatorInstaller();
        system.lookupAndSetUserProfileFactoryInstaller();
        if (system.getDeploymentType().hasViewer()) {
            system.lookupAndSetClientInstaller();
        }
        if (system.getDeploymentType().isServerSideOnly()) {
            system.lookupAndSetServerListenerInstaller();
        }
        system.lookupAndSetFixturesInstaller();
        return system;
    }

}
