package org.nakedobjects.runtime.client;

import org.nakedobjects.applib.fixtures.LogonFixture;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.config.ConfigurationConstants;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.standard.ExplorationSession;
import org.nakedobjects.runtime.authentication.standard.MultiUserExplorationSession;
import org.nakedobjects.runtime.authentication.standard.SimpleSession;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.DeploymentType;


public abstract class NakedObjectClientAbstract implements NakedObjectClient {
    private static final String NAKEDOBJECTS_USERS = ConfigurationConstants.ROOT + "exploration.users";
    protected AuthenticationManager authenticationManager;
    protected String title;

    private DeploymentType deploymentType;
    private LogonFixture logonFixture;
    private AuthenticationRequest authenticationRequestViaArgs;

    // ////////////////////////////////////
    // run, shutdown
    // ////////////////////////////////////

    public abstract void run();

    public void shutdown() {
        System.exit(0);
    }

    // ////////////////////////////////////
    // login
    // ////////////////////////////////////

    protected boolean login() {
        AuthenticationSession session = null;

        // logon fixture provided
        if ((deploymentType.isExploring() || deploymentType.isPrototyping()) && logonFixture != null) {
            session = new SimpleSession(logonFixture.getUsername(), logonFixture.getRoles());
        }

        // exploring
        if (session == null && deploymentType.isExploring()) {
            final String users = NakedObjectsContext.getConfiguration().getString(NAKEDOBJECTS_USERS);
            if (users == null) {
                session = new ExplorationSession();
            } else {
                session = new MultiUserExplorationSession(users);
            }
        }

        // otherwise, prompt...
        while (session == null) {
            AuthenticationRequest request = authenticationRequestViaArgs;
            if (request == null) {
                request = promptForAuthenticationDetails();
            }
            if (request == null) {
                return false;
            }
            session = authenticationManager.authenticate(request);
            authenticationRequestViaArgs = null;
        }
        NakedObjectsContext.openSession(session);
        return true;
    }

    // ////////////////////////////////////
    // Hook methods
    // ////////////////////////////////////

    protected abstract AuthenticationRequest promptForAuthenticationDetails();

    // ////////////////////////////////////
    // Settings
    // ////////////////////////////////////

    public void setTitle(final String title) {
        this.title = title;
    }

    public void setDeploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType;
    }

    public void setLogonFixture(LogonFixture logonFixture) {
        this.logonFixture = logonFixture;
    }

    public void setAuthenticationRequestViaArgs(final AuthenticationRequest authenticationRequest) {
        this.authenticationRequestViaArgs = authenticationRequest;
    }

    protected boolean isInExplorationMode() {
        return deploymentType.isExploring();
    }

    // ////////////////////////////////////
    // Dependencies (injected)
    // ////////////////////////////////////

    public void setAuthenticationManager(final AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

}

// Copyright (c) Naked Objects Group Ltd.
