package org.nakedobjects.runtime.i18n.resourcebundle;

import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.specloader.FacetDecoratorInstaller;
import org.nakedobjects.runtime.installers.InstallerAbstract;


public class ResourceBasedI18nDecoratorInstaller extends InstallerAbstract implements FacetDecoratorInstaller {

    public FacetDecorator createDecorator() {
        final ResourceBasedI18nManager manager = new ResourceBasedI18nManager(getConfiguration());
        return new I18nFacetDecorator(manager);
    }

    public String getName() {
        return "resource-i18n";
    }
}
