package org.nakedobjects.runtime.installers;

import org.nakedobjects.metamodel.commons.component.Installer;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.provider.NakedObjectConfigurationProvider;
import org.nakedobjects.metamodel.config.provider.NakedObjectConfigurationProviderAware;

public abstract class InstallerAbstract implements Installer, NakedObjectConfigurationProviderAware {

    private NakedObjectConfigurationProvider configurationProvider;

    
    public void setConfigurationProvider(NakedObjectConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    /**
     * Returns a <i>snapshot</i> of the current configuration provided by the
     * {@link #setConfigurationProvider(NakedObjectConfigurationProvider) injected}
     * {@link NakedObjectConfigurationProvider}.
     * 
     * <p>
     * Implementation note: the implementation is in fact just {@link InstallerLookupImpl}.
     */
    public NakedObjectConfiguration getConfiguration() {
        if (configurationProvider == null) {
            throw new IllegalStateException("ConfigurationProvider has not been injected");
        }
        return configurationProvider.getConfiguration();
    }
}


// Copyright (c) Naked Objects Group Ltd.
