package org.nakedobjects.runtime.memento;

import java.util.Enumeration;
import java.util.Hashtable;

import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;


class ObjectData extends Data {
    private static final long serialVersionUID = 7121411963269613347L;
    private final static Encodable NO_ENTRY = new Null();
    private final Hashtable fields = new Hashtable();

    public ObjectData(final Oid oid, final String resolveState, final String className) {
        super(oid, resolveState, className);
    }

    public ObjectData(final ByteDecoder decoder) {
        super(decoder);

        final int size = decoder.getInt();
        for (int i = 0; i < size; i++) {
            final String key = decoder.getString();
            final String type = decoder.getString();
            if (type.equals("O")) {
                final Data object = (Data) decoder.getObject();
                fields.put(key, object);
            } else {
                final String value = decoder.getString();
                fields.put(key, value);
            }
        }
    }

    public void addField(final String fieldName, final Object entry) {
        if (fields.containsKey(fieldName)) {
            throw new IllegalArgumentException("Field already entered " + fieldName);
        }
        fields.put(fieldName, entry == null ? NO_ENTRY : entry);
    }

    @Override
    public void debug(final DebugString debug) {
        super.debug(debug);
        for (final Enumeration f = fields.keys(); f.hasMoreElements();) {
            final String key = (String) f.nextElement();
            final Object value = fields.get(key);

            debug.appendln(key, value);

            // TODO recurse!
        }
    }

    @Override
    public void encode(ByteEncoder encoder) {
        super.encode(encoder);

        encoder.add(fields.size());

        for (final Enumeration f = fields.keys(); f.hasMoreElements();) {
            final String key = (String) f.nextElement();
            final Object value = fields.get(key);

            encoder.add(key);
            if (value instanceof Data || value instanceof Null) {
                encoder.add("O");
                encoder.add(value);
            } else {
                encoder.add("S");
                encoder.add((String) value);
            }
        }
    }

    public Object getEntry(final String fieldName) {
        final Object entry = fields.get(fieldName);
        return entry == null || entry.getClass() == NO_ENTRY.getClass() ? null : entry;
    }

    @Override
    public String toString() {
        return fields.toString();
    }

    public boolean containsField() {
        return fields != null && fields.size() > 0;
    }
}
// Copyright (c) Naked Objects Group Ltd.
