package org.nakedobjects.runtime.persistence.oidgenerator;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.component.Injectable;
import org.nakedobjects.metamodel.commons.component.SessionScopedComponent;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;


public interface OidGenerator<T extends Oid> extends DebugInfo, SessionScopedComponent, Injectable {


    /**
     * Create a new {@link Oid#isTransient() transient} {@link Oid} for the
     * supplied pojo, uniquely distinguishable from any other {@link Oid}.
     */
    T createTransientOid(Object pojo);

    /**
     * Convert the {@link Oid} from {@link Oid#isTransient() transient} to
     * persistent, storing the previous {@link Oid} as {@link Oid#getPrevious()}
     * 
     * <p>
     * Implementation notes:
     * <ul>
     * <li>Note that the {@link AdapterManager} will need to be updated so that the
     *     {@link NakedObject adapter} is re-mapped by the new {@link Oid}.  However,
     *     the <i>not</i> the responsibility of the {@link OidGenerator} to do this; 
     *     it merely ensures that the {@link Oid} is in the correct new state.
     * <li>Some implementations may require that state be set up on the {@link Oid}
     *     prior to call.  Check for details.
     * </ul>
     */
    void convertTransientToPersistentOid(T oid);

}
// Copyright (c) Naked Objects Group Ltd.
