package org.nakedobjects.runtime.persistence.oidgenerator;

import org.nakedobjects.metamodel.adapter.oid.Oid;


public abstract class OidGeneratorAbstract<T extends Oid> implements OidGenerator<T> {


    ////////////////////////////////////////////////////////////////
    // open, close (session scoped)
    ////////////////////////////////////////////////////////////////

    /**
     * Default implementation does nothing.
     */
    public void open() {}
    
    /**
     * Default implementation does nothing.
     */
    public void close() {}

    

    // ////////////////////////////////////////////////////////////////////
    // injectInto
    // ////////////////////////////////////////////////////////////////////

    public void injectInto(Object candidate) {
        if (OidGeneratorAware.class.isAssignableFrom(candidate.getClass())) {
            OidGeneratorAware cast = OidGeneratorAware.class.cast(candidate);
            cast.setOidGenerator(this);
        }
    }



}
// Copyright (c) Naked Objects Group Ltd.
