package org.nakedobjects.runtime.persistence.services;

import java.util.ArrayList;
import java.util.List;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.criteria.InstancesCriteriaAllInstances;
import org.nakedobjects.metamodel.criteria.InstancesCriteriaTitle;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;


public class RepositoryHelper {

    public static Object[] allInstances(final Class<?> cls) {
        return allInstances(getSpecificationLoader().loadSpecification(cls), cls);
    }

    public static Object[] allInstances(final NakedObjectSpecification spec, final Class<?> cls) {
        final InstancesCriteriaAllInstances allInstances = new InstancesCriteriaAllInstances(spec);
        final NakedObject instances = getPersistenceSession().findInstances(allInstances);
        final Object[] array = convertToArray(instances, cls);
        return array;
    }

    private static List<Object> convertToList(final NakedObject instances, final Class<?> cls) {
        final CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(instances);
        final List<Object> list = new ArrayList<Object>();
        for(final NakedObject adapter: facet.iterable(instances)) {
            list.add(adapter.getObject());
        }
        return list;
    }

    private static Object[] convertToArray(final NakedObject instances, final Class<?> cls) {
        return convertToList(instances, cls).toArray();
    }

    public static List<Object> findByCriteria(final InstancesCriteria criteria, final Class<?> cls) {
        final NakedObject instances = getPersistenceSession().findInstances(criteria);
        return convertToList(instances, cls);

    }

    public static List<Object> findByTitle(final Class<?> type, final String title) {
        return findByTitle(getSpecificationLoader().loadSpecification(type), type, title);
    }

    public static List<Object> findByTitle(
            final NakedObjectSpecification spec,
            final Class<?> cls,
            final String title) {
        final InstancesCriteria criteria = new InstancesCriteriaTitle(spec, title);
        return findByCriteria(criteria, cls);
    }

    public static boolean hasInstances(final Class<?> type) {
        return hasInstances(getSpecificationLoader().loadSpecification(type));
    }

    public static boolean hasInstances(final NakedObjectSpecification spec) {
        return getPersistenceSession().hasInstances(spec);
    }

	private static PersistenceSession getPersistenceSession() {
		return NakedObjectsContext.getPersistenceSession();
	}

	private static SpecificationLoader getSpecificationLoader() {
		return NakedObjectsContext.getSpecificationLoader();
	}


}
// Copyright (c) Naked Objects Group Ltd.
