package org.nakedobjects.runtime.system;

/**
 * Whether running on client or server side etc.
 */
public enum DeploymentType {
    
    EXPLORATION       (false,  false, DeploymentCategory.EXPLORING),
    PROTOTYPE         (false,  false, DeploymentCategory.PROTOTYPING),
    STANDALONE        (false,  false, DeploymentCategory.PRODUCTION),
    CLIENT            (true,   false, DeploymentCategory.PRODUCTION),
    SERVER_EXPLORATION(false,  true,  DeploymentCategory.EXPLORING),
    SERVER_PROTOTYPE  (false,  true,  DeploymentCategory.PROTOTYPING),
    SERVER            (false,  true,  DeploymentCategory.PRODUCTION);

    private final boolean isClientSideOnly;
    private final boolean isServerSideOnly;
    private final DeploymentCategory category;

    private DeploymentType(
            final boolean isClientSideOnly, 
            final boolean isServerSideOnly, 
            final DeploymentCategory category) {
        this.isClientSideOnly = isClientSideOnly;
        this.isServerSideOnly = isServerSideOnly;
        this.category = category;
    }

    /**
     * Is strictly client-side (and therefore doesn't have an object store).
     */
    public boolean isClientSideOnly() {
        return isClientSideOnly;
    }

    public boolean isServerSideOnly() {
        return isServerSideOnly;
    }

    public boolean canSpecifyRemoting() {
        return isClientSideOnly() || isServerSideOnly();
    }

    public boolean hasViewer() {
        return !isServerSideOnly();
    }
    
    public boolean canSpecifyObjectStore() {
        return isProduction() && !isClientSideOnly();
    }

    public boolean isMultithreaded() {
        return isServerSideOnly() && isProduction();
    }

    public boolean isExploring() {
        return category == DeploymentCategory.EXPLORING;
    }

    public boolean isPrototyping() {
        return category == DeploymentCategory.PROTOTYPING;
    }

    public boolean isProduction() {
        return category == DeploymentCategory.PRODUCTION;
    }

    public boolean shouldMonitor() {
        return isServerSideOnly() && isProduction();
    }


}