package org.nakedobjects.runtime.system;

import org.nakedobjects.metamodel.config.ConfigurationConstants;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;

public final class SystemConstants {
    
    public static final String LOGGING_CONFIG_FILE = "logging.properties";

    /**
     * Key by which requested reflector (eg via command line) is made available in 
     * {@link NakedObjectConfiguration}.
     */
    public final static String REQUESTED_REFLECTOR_KEY = ConfigurationConstants.ROOT + "args." + "reflector";

    /**
     * Key by which requested connection (eg via command line) is made available in 
     * {@link NakedObjectConfiguration}.
     */
    public final static String REQUESTED_CONNECTION_KEY = ConfigurationConstants.ROOT + "args." + "connection";

    /**
     * Key by which requested viewer (eg via command line) is made available in 
     * {@link NakedObjectConfiguration}.
     */
    public final static String REQUESTED_VIEWER_KEY = ConfigurationConstants.ROOT + "args." + "viewer";

    /**
     * Key by which requested fixture (eg via command line) is made available in 
     * {@link NakedObjectConfiguration}.
     */
    public final static String REQUESTED_FIXTURE_KEY = ConfigurationConstants.ROOT + "args." + "fixture";

    /**
     * Key by which requested persistor (via command line) is made available in 
     * {@link NakedObjectConfiguration}.
     */
    public final static String REQUESTED_DOMAIN_OBJECT_PERSISTENCE_MECHANISM_KEY = ConfigurationConstants.ROOT + "args." + "persistor";

    /**
     * Key by which requested user profile store (via command line) is made available in 
     * {@link NakedObjectConfiguration}.
     */
    public final static String REQUESTED_USER_PROFILE_STORE_KEY = ConfigurationConstants.ROOT + "args." + "profiles";

    
    public static final String LOCALE_KEY = ConfigurationConstants.ROOT + "locale";
    
    static final String SHARE_OBJECTS_ACROSS_CONTEXT_KEY = ConfigurationConstants.ROOT + "share-objects-across-context";
    static final boolean SHARE_OBJECTS_ACROSS_CONTEXT_DEFAULT = false;
    
    public static final String NOSPLASH_KEY = ConfigurationConstants.ROOT + "nosplash";
    public static final boolean NOSPLASH_DEFAULT = false;
    
    private SystemConstants() {}

}


// Copyright (c) Naked Objects Group Ltd.
