package org.nakedobjects.runtime.transaction;

import org.nakedobjects.metamodel.commons.component.Injectable;
import org.nakedobjects.metamodel.commons.component.SessionScopedComponent;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.runtime.session.NakedObjectSession;


public interface NakedObjectTransactionManager extends SessionScopedComponent, Injectable {


    //////////////////////////////////////////////////////////////////////
    // Session
    //////////////////////////////////////////////////////////////////////

    /**
     * The owning {@link NakedObjectSession}.
     *
     * <p>
     * Will be non-<tt>null</tt> when {@link #open() open}ed, but <tt>null</tt> if {@link #close() close}d .
     */
    NakedObjectSession getSession();


    //////////////////////////////////////////////////////////////////////
    // Transaction Management
    //////////////////////////////////////////////////////////////////////

    
    void startTransaction();
    
    boolean flushTransaction();

    void abortTransaction();

    /**
     * Ends the transaction if nesting level is 0. 
     */
    void endTransaction();


    /**
     * The current transaction, if any.
     */
    NakedObjectTransaction getTransaction();

    
    //////////////////////////////////////////////////////////////////////
    // Debugging
    //////////////////////////////////////////////////////////////////////

    void debugData(DebugString debug);



}

// Copyright (c) Naked Objects Group Ltd.
