package org.nakedobjects.runtime.transaction.facetdecorator.standard;

import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionClearFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertyClearFacet;
import org.nakedobjects.metamodel.facets.properties.modify.PropertySetterFacet;
import org.nakedobjects.runtime.transaction.facetdecorator.TransactionFacetDecoratorAbstract;
import org.nakedobjects.runtime.transaction.facets.ActionInvocationFacetWrapTransaction;
import org.nakedobjects.runtime.transaction.facets.CollectionAddToFacetWrapTransaction;
import org.nakedobjects.runtime.transaction.facets.CollectionClearFacetWrapTransaction;
import org.nakedobjects.runtime.transaction.facets.CollectionRemoveFromFacetWrapTransaction;
import org.nakedobjects.runtime.transaction.facets.PropertyClearFacetWrapTransaction;
import org.nakedobjects.runtime.transaction.facets.ProxySetterFacetWrapTransaction;


public class StandardTransactionFacetDecorator extends TransactionFacetDecoratorAbstract {

    public StandardTransactionFacetDecorator(NakedObjectConfiguration configuration) {
        super(configuration);
    }

    public Facet decorate(final Facet facet, final FacetHolder holder) {
        final Class<? extends Facet> facetType = facet.facetType();
        if (facetType == ActionInvocationFacet.class) {
            ActionInvocationFacet decoratedFacet = (ActionInvocationFacet) facet;
            return new ActionInvocationFacetWrapTransaction(decoratedFacet);
        }

        if (facetType == CollectionAddToFacet.class) {
            CollectionAddToFacet decoratedFacet = (CollectionAddToFacet) facet;
            return new CollectionAddToFacetWrapTransaction(decoratedFacet);
        }

        if (facetType == CollectionClearFacet.class) {
            CollectionClearFacet decoratedFacet = (CollectionClearFacet) facet;
            return new CollectionClearFacetWrapTransaction(decoratedFacet);
        }

        if (facetType == CollectionRemoveFromFacet.class) {
            CollectionRemoveFromFacet decoratedFacet = (CollectionRemoveFromFacet) facet;
            return new CollectionRemoveFromFacetWrapTransaction(decoratedFacet);
        }

        if (facetType == PropertyClearFacet.class) {
            PropertyClearFacet decoratedFacet = (PropertyClearFacet) facet;
            return new PropertyClearFacetWrapTransaction(decoratedFacet);
        }

        if (facetType == PropertySetterFacet.class) {
            PropertySetterFacet decoratedFacet = (PropertySetterFacet) facet;
            return new ProxySetterFacetWrapTransaction(decoratedFacet);
        }

        return facet;
    }

}

// Copyright (c) Naked Objects Group Ltd.
