package org.nakedobjects.runtime.transaction.facets;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionClearFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionClearFacetAbstract;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.TransactionUtils;


public class CollectionClearFacetWrapTransaction extends CollectionClearFacetAbstract implements
        DecoratingFacet<CollectionClearFacet> {

    private final CollectionClearFacet underlyingFacet;

    public CollectionClearFacet getDecoratedFacet() {
        return underlyingFacet;
    }

    public CollectionClearFacetWrapTransaction(final CollectionClearFacet underlyingFacet) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
    }

    public void clear(final NakedObject inAdapter) {
        if (!inAdapter.isPersistent()) {
            underlyingFacet.clear(inAdapter);
            return;
        }
        try {
            getTransactionManager().startTransaction();
            underlyingFacet.clear(inAdapter);
            getTransactionManager().endTransaction();
        } catch (final RuntimeException e) {
            TransactionUtils.abort(getTransactionManager(), getFacetHolder());
            throw e;
        }
    }

    @Override
    public String toString() {
        return super.toString() + " --> " + underlyingFacet.toString();
    }

    
    /////////////////////////////////////////////////////////////////
    // Dependencies (from context)
    /////////////////////////////////////////////////////////////////
    
    private static NakedObjectTransactionManager getTransactionManager() {
        return getPersistenceSession().getTransactionManager();
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }



}

// Copyright (c) Naked Objects Group Ltd.
