package org.nakedobjects.runtime.authentication.standard;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.sameInstance;
import static org.junit.Assert.assertThat;

import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.runtime.authentication.standard.AuthenticationManagerStandard;
import org.nakedobjects.runtime.authentication.standard.Authenticator;
import org.nakedobjects.runtime.authentication.standard.AuthenticatorNoop;

public class StandardAuthenticationManager_Authenticators {

    private AuthenticationManagerStandard authenticationManager;


    @Before
    public void setUp() throws Exception {
        authenticationManager = new AuthenticationManagerStandard();
    }


    @Test
    public void shouldInitiallyHaveNoAuthenticators() throws Exception {
        assertThat(authenticationManager.getAuthenticators().size(), is(0));
    }

    @Test
    public void shouldBeAbleToAddAuthenticators() throws Exception {
        Authenticator authenticator = new AuthenticatorNoop();
        authenticationManager.addAuthenticator(authenticator);
        assertThat(authenticationManager.getAuthenticators().size(), is(1));
        assertThat(authenticationManager.getAuthenticators().get(0), is(sameInstance(authenticator)));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotBeAbleToModifyReturnedAuthenticators() throws Exception {
        List<Authenticator> authenticators = authenticationManager.getAuthenticators();
        authenticators.add(new AuthenticatorNoop());
    }

}


// Copyright (c) Naked Objects Group Ltd.
