/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard;

import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.runtime.authentication.standard.MultiUserExplorationSession;

public class MultiUserExplorationSessionTest {
    private MultiUserExplorationSession session;

    @Before
    public void setUp() {
        this.session = new MultiUserExplorationSession("fred, sven:admin|sales|marketing, bob:sales, dick");
    }

    @Test
    public void testNameDefaultsToFirstUser() throws Exception {
        Assert.assertEquals((String)"fred", (String)this.session.getUserName());
    }

    @Test
    public void testNoValidateCode() throws Exception {
        Assert.assertEquals((String)"", (String)this.session.getValidationCode());
    }

    @Test
    public void testNoRolesSpecifiedForFirstUser() throws Exception {
        Assert.assertEquals((int)0, (int)this.session.getRoles().length);
    }

    @Test
    public void testForMultipleUser() throws Exception {
        Assert.assertEquals((boolean)true, (boolean)this.session.hasMultipleUsers());
    }

    @Test
    public void testForSingleUser() throws Exception {
        this.session = new MultiUserExplorationSession("sven");
        Assert.assertEquals((boolean)false, (boolean)this.session.hasMultipleUsers());
        Assert.assertEquals((String)"sven", (String)this.session.getUserName());
    }

    @Test(expected=NakedObjectException.class)
    public void testNoUsersSpecified() throws Exception {
        new MultiUserExplorationSession("");
    }

    @Test
    public void testOtherUsers() throws Exception {
        List availableSessions = this.session.getUserNames();
        Assert.assertEquals((int)4, (int)availableSessions.size());
        Assert.assertTrue((boolean)availableSessions.contains("fred"));
        Assert.assertTrue((boolean)availableSessions.contains("sven"));
        Assert.assertTrue((boolean)availableSessions.contains("bob"));
        Assert.assertTrue((boolean)availableSessions.contains("dick"));
    }

    @Test
    public void testChangeUser() throws Exception {
        this.session.setCurrentSession("bob");
        Assert.assertEquals((String)"bob", (String)this.session.getUserName());
    }

    @Test
    public void testRolesExist() throws Exception {
        this.session.setCurrentSession("sven");
        String[] roles = this.session.getRoles();
        Assert.assertEquals((int)3, (int)roles.length);
        Assert.assertEquals((String)"admin", (String)roles[0]);
        Assert.assertEquals((String)"sales", (String)roles[1]);
        Assert.assertEquals((String)"marketing", (String)roles[2]);
    }
}

