/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.runtime.authentication.standard.AuthenticationManagerStandard;
import org.nakedobjects.runtime.authentication.standard.Authenticator;
import org.nakedobjects.runtime.authentication.standard.AuthenticatorNoop;

public class StandardAuthenticationManager_Authenticators {
    private AuthenticationManagerStandard authenticationManager;

    @Before
    public void setUp() throws Exception {
        this.authenticationManager = new AuthenticationManagerStandard();
    }

    @Test
    public void shouldInitiallyHaveNoAuthenticators() throws Exception {
        Assert.assertThat((Object)this.authenticationManager.getAuthenticators().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldBeAbleToAddAuthenticators() throws Exception {
        AuthenticatorNoop authenticator = new AuthenticatorNoop();
        this.authenticationManager.addAuthenticator((Authenticator)authenticator);
        Assert.assertThat((Object)this.authenticationManager.getAuthenticators().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(this.authenticationManager.getAuthenticators().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)authenticator)));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotBeAbleToModifyReturnedAuthenticators() throws Exception {
        List authenticators = this.authenticationManager.getAuthenticators();
        authenticators.add(new AuthenticatorNoop());
    }
}

