/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.memento;

import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.config.prop.PropertiesConfiguration;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.specloader.NakedObjectReflector;
import org.nakedobjects.runtime.context.NakedObjectsContextStatic;
import org.nakedobjects.runtime.memento.CollectionData;
import org.nakedobjects.runtime.memento.Data;
import org.nakedobjects.runtime.memento.Memento;
import org.nakedobjects.runtime.memento.TestObject;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.session.NakedObjectSession;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;

public class MementoTest3 {
    private Mockery mockery = new JUnit4Mockery();
    private NakedObject rootAdapter;
    private NakedObject returnedAdapter;
    private TestObject rootObject;
    private TestObject recreatedObject;
    private Oid oid;
    private Data data;
    private Memento memento;
    private NakedObjectSpecification emptySpecification;
    private NakedObject element1;

    @Before
    public void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        this.emptySpecification = (NakedObjectSpecification)this.mockery.mock(NakedObjectSpecification.class, "empty specification");
        final NakedObjectSpecification rootSpecification = (NakedObjectSpecification)this.mockery.mock(NakedObjectSpecification.class);
        OneToOneAssociation nameField = (OneToOneAssociation)this.mockery.mock(OneToOneAssociation.class);
        NakedObjectSpecification elementSpecification = (NakedObjectSpecification)this.mockery.mock(NakedObjectSpecification.class, "name specification");
        final CollectionFacet collectionFacet = (CollectionFacet)this.mockery.mock(CollectionFacet.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectSpecification)this.atLeast(1).of((Object)rootSpecification)).isCollection();
                this.will(1.returnValue((Object)true));
                ((NakedObjectSpecification)this.atLeast(1).of((Object)rootSpecification)).getFullName();
                this.will(1.returnValue((Object)TestObject[].class.getName()));
                ((NakedObjectSpecification)this.atLeast(1).of((Object)rootSpecification)).getFacet(CollectionFacet.class);
                this.will(1.returnValue((Object)collectionFacet));
                ((NakedObjectSpecification)this.atLeast(0).of((Object)MementoTest3.this.emptySpecification)).getFullName();
                this.will(1.returnValue((Object)TestObject.class.getName()));
            }
        });
        this.rootAdapter = (NakedObject)this.mockery.mock(NakedObject.class);
        this.rootObject = new TestObject("Harry");
        NakedObject nameAdapter = (NakedObject)this.mockery.mock(NakedObject.class, "name");
        this.oid = (Oid)this.mockery.mock(Oid.class);
        final TypeOfFacet typeOfFacet = (TypeOfFacet)this.mockery.mock(TypeOfFacet.class, "element 1");
        final Iterator iterator = (Iterator)this.mockery.mock(Iterator.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((CollectionFacet)this.atLeast(1).of((Object)collectionFacet)).size(MementoTest3.this.rootAdapter);
                this.will(2.returnValue((Object)2));
                ((CollectionFacet)this.atLeast(1).of((Object)collectionFacet)).getTypeOfFacet();
                this.will(2.returnValue((Object)typeOfFacet));
                ((TypeOfFacet)this.atLeast(1).of((Object)typeOfFacet)).valueSpec();
                this.will(2.returnValue((Object)rootSpecification));
                ((CollectionFacet)this.atLeast(1).of((Object)collectionFacet)).iterator(MementoTest3.this.rootAdapter);
                this.will(2.returnValue((Object)iterator));
                ((Iterator)this.one(iterator)).hasNext();
                this.will(2.returnValue((Object)true));
                ((Iterator)this.one(iterator)).next();
                MementoTest3.this.element1 = MementoTest3.this.nakedObject("element", 1, false);
                this.will(2.returnValue((Object)MementoTest3.this.element1));
                ((Iterator)this.one(iterator)).hasNext();
                this.will(2.returnValue((Object)true));
                ((Iterator)this.one(iterator)).next();
                this.will(2.returnValue((Object)MementoTest3.this.nakedObject("element", 2, false)));
                ((Iterator)this.one(iterator)).hasNext();
                this.will(2.returnValue((Object)false));
                ((NakedObject)this.atLeast(1).of((Object)MementoTest3.this.rootAdapter)).getSpecification();
                this.will(2.returnValue((Object)rootSpecification));
                ((NakedObject)this.atLeast(1).of((Object)MementoTest3.this.rootAdapter)).getOid();
                this.will(2.returnValue((Object)MementoTest3.this.oid));
                ((NakedObject)this.atLeast(1).of((Object)MementoTest3.this.rootAdapter)).getResolveState();
                this.will(2.returnValue((Object)ResolveState.RESOLVED));
            }
        });
        this.mockery.checking((ExpectationBuilder)new Expectations(){});
        NakedObjectReflector reflector = (NakedObjectReflector)this.mockery.mock(NakedObjectReflector.class);
        PersistenceSession mockPersistenceSession = (PersistenceSession)this.mockery.mock(PersistenceSession.class);
        NakedObjectSessionFactory sessionFactory = (NakedObjectSessionFactory)this.mockery.mock(NakedObjectSessionFactory.class);
        AuthenticationSession mockSession = (AuthenticationSession)this.mockery.mock(AuthenticationSession.class);
        NakedObjectSession session = (NakedObjectSession)this.mockery.mock(NakedObjectSession.class);
        NakedObjectsContextStatic.createRelaxedInstance((NakedObjectSessionFactory)sessionFactory);
        this.memento = new Memento(this.rootAdapter);
        this.data = this.memento.getData();
    }

    public NakedObject nakedObject(String name, int id, final boolean isTransient) {
        final NakedObject object = (NakedObject)this.mockery.mock(NakedObject.class, name + id);
        final Oid oid = (Oid)this.mockery.mock(Oid.class, name + "#" + id);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObject)this.atLeast(0).of((Object)object)).getOid();
                this.will(4.returnValue((Object)oid));
                ((NakedObject)this.atLeast(0).of((Object)object)).getResolveState();
                this.will(4.returnValue((Object)ResolveState.TRANSIENT));
                ((NakedObject)this.atLeast(0).of((Object)object)).getSpecification();
                this.will(4.returnValue((Object)MementoTest3.this.emptySpecification));
                ((Oid)this.atLeast(0).of((Object)oid)).isTransient();
                this.will(4.returnValue((Object)isTransient));
            }
        });
        return object;
    }

    @Ignore(value="currently failing - is no longer calling  isTransient on element #1 and element #2")
    @Test
    public void testOid() throws Exception {
        Assert.assertEquals((Object)this.oid, (Object)this.data.getOid());
        this.mockery.assertIsSatisfied();
    }

    @Ignore(value="currently failing - is no longer calling  isTransient on element #1 and element #2")
    @Test
    public void testResolved() throws Exception {
        Assert.assertEquals((Object)ResolveState.RESOLVED.name(), (Object)this.data.getResolveState());
        this.mockery.assertIsSatisfied();
    }

    @Ignore(value="currently failing - is no longer calling  isTransient on element #1 and element #2")
    @Test
    public void testClassName() throws Exception {
        Assert.assertEquals((Object)TestObject[].class.getName(), (Object)this.data.getClassName());
        this.mockery.assertIsSatisfied();
    }

    @Ignore(value="currently failing - is no longer calling  isTransient on element #1 and element #2")
    @Test
    public void testDataType() throws Exception {
        Assert.assertEquals(CollectionData.class, this.data.getClass());
        this.mockery.assertIsSatisfied();
    }

    @Ignore(value="currently failing - is no longer calling  isTransient on element #1 and element #2")
    @Test
    public void testDataLength() throws Exception {
        Assert.assertEquals((long)2L, (long)((CollectionData)this.data).elements.length);
        this.mockery.assertIsSatisfied();
    }

    @Ignore(value="currently failing - is no longer calling  isTransient on element #1 and element #2")
    @Test
    public void testData() throws Exception {
        final ByteEncoder encoder = (ByteEncoder)this.mockery.mock(ByteEncoder.class);
        final Oid oid1 = this.element1.getOid();
        final Oid oid2 = this.element1.getOid();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ByteEncoder)this.one(encoder)).add(TestObject.class.getName());
                ((ByteEncoder)this.one(encoder)).add(ResolveState.RESOLVED.name());
                ((ByteEncoder)this.one(encoder)).add((Object)MementoTest3.this.oid);
                ((ByteEncoder)this.one(encoder)).add(TestObject[].class.getName());
                ((ByteEncoder)this.one(encoder)).add(2);
                ((ByteEncoder)this.one(encoder)).add(TestObject.class.getName());
                ((ByteEncoder)this.one(encoder)).add(ResolveState.TRANSIENT.name());
                ((ByteEncoder)this.one(encoder)).add((Object)oid1);
                ((ByteEncoder)this.one(encoder)).add(TestObject.class.getName());
                ((ByteEncoder)this.one(encoder)).add(ResolveState.TRANSIENT.name());
                ((ByteEncoder)this.one(encoder)).add((Object)oid2);
            }
        });
        this.memento.encodedData(encoder);
        this.mockery.assertIsSatisfied();
    }
}

