/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.objectstore.inmemory;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.criteria.InstancesCriteriaTitle;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.testspec.TestProxySpecification;
import org.nakedobjects.runtime.objectstore.inmemory.InMemoryObjectStore;
import org.nakedobjects.runtime.persistence.ObjectNotFoundException;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestPojo;
import org.nakedobjects.runtime.testsystem.TestProxyOid;

public class EmptyMemoryObjectStoreTest
extends ProxyJunit3TestCase {
    private InMemoryObjectStore store;

    protected void setUp() throws Exception {
        super.setUp();
        this.store = new InMemoryObjectStore();
        this.store.open();
    }

    public void testStartsUpInUnitializedSate() throws Exception {
        EmptyMemoryObjectStoreTest.assertFalse((boolean)this.store.isFixturesInstalled());
    }

    public void testFindNoInstances() throws Exception {
        TestProxySpecification spec = this.system.getSpecification(TestPojo.class);
        NakedObject[] instances = this.store.getInstances((InstancesCriteria)new InstancesCriteriaTitle((NakedObjectSpecification)spec, "title"));
        EmptyMemoryObjectStoreTest.assertEquals((int)0, (int)instances.length);
    }

    public void testHasNoInstances() throws Exception {
        TestProxySpecification spec = this.system.getSpecification(TestPojo.class);
        EmptyMemoryObjectStoreTest.assertFalse((boolean)this.store.hasInstances((NakedObjectSpecification)spec));
    }

    public void testCantFindObjectByOid() {
        TestProxySpecification spec = this.system.getSpecification(TestPojo.class);
        TestProxyOid oid = new TestProxyOid(10, true);
        try {
            this.store.getObject((Oid)oid, (NakedObjectSpecification)spec);
            EmptyMemoryObjectStoreTest.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public void testName() throws Exception {
        EmptyMemoryObjectStoreTest.assertEquals((String)"In-Memory Object Store", (String)this.store.name());
    }

    public void testOidForService() throws Exception {
        Oid oidForService = this.store.getOidForService("service name");
        EmptyMemoryObjectStoreTest.assertEquals(null, (Object)oidForService);
    }
}

