/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.objectstore.inmemory;

import java.util.Collections;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.criteria.InstancesCriteriaAllInstances;
import org.nakedobjects.metamodel.criteria.InstancesCriteriaTitle;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.objectstore.inmemory.InMemoryObjectStore;
import org.nakedobjects.runtime.persistence.ObjectNotFoundException;
import org.nakedobjects.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyNakedObject;
import org.nakedobjects.runtime.testsystem.TestProxyOid;

public class MemoryObjectStoreTest
extends ProxyJunit3TestCase {
    private InMemoryObjectStore store;

    protected void setUp() throws Exception {
        super.setUp();
        this.store = new InMemoryObjectStore();
        this.system.getPersistenceSession().injectInto((Object)this.store);
        this.store.open();
    }

    protected void tearDown() throws Exception {
        this.store.close();
        super.tearDown();
    }

    public void testObjectNotPersistedWhenCreated() throws Exception {
        NakedObject object = this.system.createPersistentTestObject();
        NakedObjectSpecification specification = object.getSpecification();
        MemoryObjectStoreTest.assertEquals((boolean)false, (boolean)this.store.hasInstances(specification));
        MemoryObjectStoreTest.assertEquals((int)0, (int)this.store.getInstances((InstancesCriteria)new InstancesCriteriaAllInstances(specification)).length);
        try {
            this.store.getObject(object.getOid(), specification);
            MemoryObjectStoreTest.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public void testRetrievedInstanceAdapterIsIsolatedFromOriginal() throws Exception {
        NakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        this.resetIdentityMap();
        NakedObjectSpecification specification = object.getSpecification();
        NakedObject[] retrievedInstance = this.store.getInstances((InstancesCriteria)new InstancesCriteriaAllInstances(specification));
        MemoryObjectStoreTest.assertEquals((int)1, (int)retrievedInstance.length);
        MemoryObjectStoreTest.assertSame((Object)object.getObject(), (Object)retrievedInstance[0].getObject());
        MemoryObjectStoreTest.assertNotSame((Object)object, (Object)retrievedInstance[0]);
    }

    public void testRetrievedObjectAdapterIsIsolatedFromOriginal() throws Exception {
        NakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        this.resetIdentityMap();
        NakedObjectSpecification specification = object.getSpecification();
        NakedObject retrievedObject = this.store.getObject(object.getOid(), specification);
        MemoryObjectStoreTest.assertNotSame((Object)object, (Object)retrievedObject);
        MemoryObjectStoreTest.assertEquals((Object)object.getObject(), (Object)retrievedObject.getObject());
    }

    public void testResetClearsAdapterFromLoader() throws Exception {
        NakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        this.resetIdentityMap();
        MemoryObjectStoreTest.assertNull((Object)MemoryObjectStoreTest.getAdapterManager().getAdapterFor(object.getObject()));
    }

    public void testHasInstances() throws Exception {
        NakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        this.resetIdentityMap();
        NakedObjectSpecification specification = object.getSpecification();
        MemoryObjectStoreTest.assertEquals((boolean)true, (boolean)this.store.hasInstances(specification));
    }

    public void testRetrievedInstancesByTitle() throws Exception {
        NakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        this.resetIdentityMap();
        NakedObjectSpecification specification = object.getSpecification();
        NakedObject[] retrievedInstance = this.store.getInstances((InstancesCriteria)new InstancesCriteriaTitle(specification, "le STR"));
        MemoryObjectStoreTest.assertEquals((int)1, (int)retrievedInstance.length);
        MemoryObjectStoreTest.assertNotSame((Object)object, (Object)retrievedInstance[0]);
        MemoryObjectStoreTest.assertSame((Object)object.getObject(), (Object)retrievedInstance[0].getObject());
    }

    public void testOidForService() throws Exception {
        TestProxyOid oid = new TestProxyOid(14);
        this.store.registerService("service name", (Oid)oid);
        this.resetIdentityMap();
        Oid oidForService = this.store.getOidForService("service name");
        MemoryObjectStoreTest.assertEquals((Object)oid, (Object)oidForService);
    }

    private void resetIdentityMap() {
        NakedObjectsContext.getPersistenceSession().testReset();
    }

    public void testCantRegisterServiceMoreThanOnce() throws Exception {
        TestProxyOid oid = new TestProxyOid(14);
        this.store.registerService("service name", (Oid)oid);
        oid = new TestProxyOid(15);
        try {
            this.store.registerService("service name", (Oid)oid);
            MemoryObjectStoreTest.fail();
        }
        catch (NakedObjectException nakedObjectException) {
            // empty catch block
        }
    }

    public void testRemoveInstance() throws Exception {
        NakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        this.resetIdentityMap();
        DestroyObjectCommand command = this.store.createDestroyObjectCommand(object);
        MemoryObjectStoreTest.assertEquals((Object)object, (Object)command.onObject());
        this.store.execute(Collections.singletonList(command));
        this.resetIdentityMap();
        NakedObjectSpecification specification = object.getSpecification();
        MemoryObjectStoreTest.assertEquals((boolean)false, (boolean)this.store.hasInstances(specification));
    }

    public void testSaveInstance() throws Exception {
        NakedObject object = this.system.createPersistentTestObject();
        this.addObjectToStore(object);
        this.resetIdentityMap();
        NakedObjectSpecification specification = object.getSpecification();
        NakedObject[] retrievedInstance = this.store.getInstances((InstancesCriteria)new InstancesCriteriaTitle(specification, "changed"));
        MemoryObjectStoreTest.assertEquals((int)0, (int)retrievedInstance.length);
        ((TestProxyNakedObject)object).setupTitleString("changed title");
        SaveObjectCommand command = this.store.createSaveObjectCommand(object);
        MemoryObjectStoreTest.assertEquals((Object)object, (Object)command.onObject());
        this.store.execute(Collections.singletonList(command));
        this.resetIdentityMap();
        retrievedInstance = this.store.getInstances((InstancesCriteria)new InstancesCriteriaTitle(specification, "changed"));
        MemoryObjectStoreTest.assertEquals((int)1, (int)retrievedInstance.length);
        MemoryObjectStoreTest.assertNotSame((Object)object, (Object)retrievedInstance[0]);
    }

    private void addObjectToStore(NakedObject object) {
        CreateObjectCommand command = this.store.createCreateObjectCommand(object);
        MemoryObjectStoreTest.assertEquals((Object)object, (Object)command.onObject());
        this.store.execute(Collections.singletonList(command));
    }
}

