/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore;

import java.util.Collections;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.DomainObjectContainer;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.services.ServicesInjectorDefault;
import org.nakedobjects.metamodel.services.container.DomainObjectContainerDefault;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.PersistenceSessionTransactionManagement;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.internal.RuntimeContextFromSession;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactoryBasic;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStorePersistence;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStoreSpy;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStoreTransactionManagement;
import org.nakedobjects.runtime.persistence.objectstore.PersistenceSessionObjectStore;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.PersistAlgorithm;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.dummy.DummyPersistAlgorithm;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransactionManager;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.testsystem.TestProxyOidGenerator;
import org.nakedobjects.runtime.testsystem.TestProxySystem;

@RunWith(value=JMock.class)
public class PersistenceSessionObjectStoreTest {
    private Mockery mockery = new JUnit4Mockery();
    private PersistenceSessionFactory mockPersistenceSessionFactory;
    private PersistenceSessionObjectStore persistenceSession;
    private ObjectStoreTransactionManager transactionManager;
    private ObjectStoreSpy objectStore;
    private NakedObject testNakedObject;
    private TestProxySystem system;
    private ServicesInjectorDefault servicesInjector;
    private AdapterManagerExtended adapterManager;
    private AdapterFactory<? extends NakedObject> adapterFactory;

    @Before
    public void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.mockPersistenceSessionFactory = (PersistenceSessionFactory)this.mockery.mock(PersistenceSessionFactory.class);
        this.system = new TestProxySystem();
        this.objectStore = new ObjectStoreSpy();
        RuntimeContextFromSession runtimeContext = new RuntimeContextFromSession();
        DomainObjectContainerDefault container = new DomainObjectContainerDefault();
        runtimeContext.injectInto((Object)container);
        runtimeContext.setContainer((DomainObjectContainer)container);
        this.servicesInjector = new ServicesInjectorDefault();
        this.servicesInjector.setContainer((DomainObjectContainer)container);
        this.adapterManager = (AdapterManagerExtended)this.system.getAdapterManager();
        this.adapterFactory = this.system.getAdapterFactory();
        this.persistenceSession = new PersistenceSessionObjectStore(this.mockPersistenceSessionFactory, this.adapterFactory, (ObjectFactory)new ObjectFactoryBasic(), (ServicesInjector)this.servicesInjector, (OidGenerator)new TestProxyOidGenerator(), this.adapterManager, (PersistAlgorithm)new DummyPersistAlgorithm(), (ObjectStorePersistence)this.objectStore);
        this.transactionManager = new ObjectStoreTransactionManager((PersistenceSessionTransactionManagement)this.persistenceSession, (ObjectStoreTransactionManagement)this.objectStore);
        this.transactionManager.injectInto((Object)this.persistenceSession);
        this.servicesInjector.setServices(Collections.emptyList());
        this.persistenceSession.setSpecificationLoader((SpecificationLoader)this.system.getReflector());
        this.system.setPersistenceSession((PersistenceSession)this.persistenceSession);
        this.system.init();
        this.testNakedObject = this.system.createPersistentTestObject();
    }

    @After
    public void tearDown() throws Exception {
        this.system.shutdown();
    }

    @Test
    public void testAbort() {
        this.objectStore.reset();
        this.transactionManager.startTransaction();
        this.persistenceSession.destroyObject(this.testNakedObject);
        this.transactionManager.abortTransaction();
        this.objectStore.assertAction(0, "startTransaction");
        this.objectStore.assertAction(1, "destroyObject " + this.testNakedObject);
        this.objectStore.assertAction(2, "abortTransaction");
        this.objectStore.assertLastAction(2);
    }

    @Test
    public void testDestroy() {
        this.objectStore.reset();
        String action = "destroyObject " + this.testNakedObject;
        this.transactionManager.startTransaction();
        this.persistenceSession.destroyObject(this.testNakedObject);
        this.transactionManager.endTransaction();
        this.objectStore.assertAction(0, "startTransaction");
        this.objectStore.assertAction(1, action);
        this.objectStore.assertAction(2, "execute DestroyObjectCommand " + this.testNakedObject);
        this.objectStore.assertAction(3, "endTransaction");
        Assert.assertEquals((long)4L, (long)this.objectStore.getActions().size());
    }

    public void testMakePersistent() {
        this.testNakedObject = this.system.createTransientTestObject();
        this.objectStore.reset();
        this.transactionManager.startTransaction();
        this.persistenceSession.makePersistent(this.testNakedObject);
        this.transactionManager.endTransaction();
        this.objectStore.assertAction(0, "startTransaction");
        this.objectStore.assertAction(1, "createObject " + this.testNakedObject);
        this.objectStore.assertAction(2, "endTransaction");
        this.objectStore.assertAction(3, "run CreateObjectCommand " + this.testNakedObject);
        Assert.assertEquals((long)4L, (long)this.objectStore.getActions().size());
    }
}

