/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore.transaction;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Sequence;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionTransactionManagement;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStoreTransactionManagement;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransactionManager;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransactionManagerAbstractTestCase;

public class ObjectStoreTransactionManager_EndTransaction
extends ObjectStoreTransactionManagerAbstractTestCase {
    @Before
    public void setUpTransactionManager() throws Exception {
        this.transactionManager = new ObjectStoreTransactionManager((PersistenceSessionTransactionManagement)this.mockPersistenceSession, this.mockObjectStore);
    }

    @Test
    public void endTransactionDecrementsTransactionLevel() throws Exception {
        this.ignoreCallsToObjectStore();
        this.transactionManager.startTransaction();
        this.transactionManager.startTransaction();
        Assert.assertThat((Object)this.transactionManager.transactionLevel, (Matcher)CoreMatchers.is((Object)2));
        this.transactionManager.endTransaction();
        Assert.assertThat((Object)this.transactionManager.transactionLevel, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void endTransactionCommitsTransactionWhenLevelDecrementsDownToZero() throws Exception {
        this.ignoreCallsToObjectStore();
        this.transactionManager.startTransaction();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((PersistenceSession)this.one(ObjectStoreTransactionManager_EndTransaction.this.mockPersistenceSession)).objectChangedAllDirty();
            }
        });
        Assert.assertThat((Object)this.transactionManager.transactionLevel, (Matcher)CoreMatchers.is((Object)1));
        this.transactionManager.endTransaction();
        Assert.assertThat((Object)this.transactionManager.transactionLevel, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void startTransactionInteractsWithObjectStore() throws Exception {
        this.ignoreCallsToPersistenceSession();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectStoreTransactionManagement)this.one(ObjectStoreTransactionManager_EndTransaction.this.mockObjectStore)).startTransaction();
            }
        });
        this.transactionManager.startTransaction();
    }

    @Test
    public void endTransactionInteractsWithObjectStore() throws Exception {
        this.ignoreCallsToPersistenceSession();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence transactionOrdering = ObjectStoreTransactionManager_EndTransaction.this.mockery.sequence("transactionOrdering");
                ((ObjectStoreTransactionManagement)this.one(ObjectStoreTransactionManager_EndTransaction.this.mockObjectStore)).startTransaction();
                this.inSequence(transactionOrdering);
                ((ObjectStoreTransactionManagement)this.one(ObjectStoreTransactionManager_EndTransaction.this.mockObjectStore)).endTransaction();
                this.inSequence(transactionOrdering);
            }
        });
        this.transactionManager.startTransaction();
        this.transactionManager.endTransaction();
    }
}

