/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore.transaction;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.runtime.persistence.PersistenceSessionTransactionManagement;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStoreTransactionManagement;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransaction;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransactionManager;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransactionManagerAbstractTestCase;

public class ObjectStoreTransactionManager_StartTransaction
extends ObjectStoreTransactionManagerAbstractTestCase {
    @Before
    public void setUpTransactionManager() throws Exception {
        this.transactionManager = new ObjectStoreTransactionManager((PersistenceSessionTransactionManagement)this.mockPersistenceSession, this.mockObjectStore);
    }

    @Before
    public void setUpExpectations() throws Exception {
        this.ignoreCallsToPersistenceSession();
    }

    @Test
    public void startTransactionCreateTransactionIfNone() throws Exception {
        this.ignoreCallsToObjectStore();
        Assert.assertThat((Object)this.transactionManager.getTransaction(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.transactionManager.startTransaction();
        Assert.assertThat((Object)this.transactionManager.getTransaction(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void startTransactionDoesNotOverwriteTransactionIfHasOne() throws Exception {
        this.ignoreCallsToObjectStore();
        this.transactionManager.startTransaction();
        ObjectStoreTransaction transactionAfterFirstStart = (ObjectStoreTransaction)this.transactionManager.getTransaction();
        this.transactionManager.startTransaction();
        Assert.assertThat((Object)this.transactionManager.getTransaction(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)transactionAfterFirstStart)));
    }

    @Test
    public void startTransactionIncrementsTransactionLevel() throws Exception {
        this.ignoreCallsToObjectStore();
        Assert.assertThat((Object)this.transactionManager.transactionLevel, (Matcher)CoreMatchers.is((Object)0));
        this.transactionManager.startTransaction();
        Assert.assertThat((Object)this.transactionManager.transactionLevel, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void startTransactionCallsStartTransactionOnObjectStore() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ObjectStoreTransactionManagement)this.one(ObjectStoreTransactionManager_StartTransaction.this.mockObjectStore)).startTransaction();
            }
        });
        this.transactionManager.startTransaction();
    }
}

