/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system;

import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;
import org.nakedobjects.metamodel.specloader.internal.TypeExtractorMethodReturn;

public class TypeExtractorMethodReturnTest {
    @Test
    public void shouldFindGenericTypes() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CustomerRepository {
            CustomerRepository() {
            }

            public List<Customer> findCustomers() {
                return null;
            }
        }
        Class<CustomerRepository> clazz = CustomerRepository.class;
        Method method = clazz.getMethod("findCustomers", new Class[0]);
        TypeExtractorMethodReturn extractor = new TypeExtractorMethodReturn(method);
        Assert.assertThat((Object)extractor.getClasses().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)extractor.getClasses(), (Matcher)NofMatchers.containsElementThat((Matcher)CoreMatchers.equalTo(List.class)));
        class Customer {
            Customer() {
            }
        }
        Assert.assertThat((Object)extractor.getClasses(), (Matcher)NofMatchers.containsElementThat((Matcher)CoreMatchers.equalTo(Customer.class)));
    }

    @Test
    public void ignoresVoidType() throws Exception {
        class CustomerRepository {
            CustomerRepository() {
            }

            public void findCustomers() {
            }
        }
        Class<CustomerRepository> clazz = CustomerRepository.class;
        Method method = clazz.getMethod("findCustomers", new Class[0]);
        TypeExtractorMethodReturn extractor = new TypeExtractorMethodReturn(method);
        Assert.assertThat((Object)extractor.getClasses().size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

