/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.testsystem.tests;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.testsystem.TestPojo;
import org.nakedobjects.runtime.testsystem.TestProxyException;
import org.nakedobjects.runtime.testsystem.TestProxyOid;
import org.nakedobjects.runtime.testsystem.TestProxySystem;

public class CreateTransientObjectsTest {
    private TestProxySystem system;
    private NakedObject adapter;
    private TestPojo pojo;
    private Oid oid;

    @Before
    public void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.system = new TestProxySystem();
        this.system.init();
        this.pojo = new TestPojo();
        this.adapter = this.system.createTransientTestObject(this.pojo);
        this.oid = this.adapter.getOid();
    }

    @Test
    public void testSpecification() {
        Assert.assertNotNull((Object)this.adapter.getSpecification());
        Assert.assertNotNull((String)TestPojo.class.getName(), (Object)this.adapter.getSpecification().getFullName());
    }

    @Test
    public void testStateOfCreatedAdapted() {
        Assert.assertNotNull((Object)this.adapter);
        Assert.assertEquals((Object)this.pojo, (Object)this.adapter.getObject());
    }

    @Test
    public void testResolveStateShowsTransient() throws Exception {
        Assert.assertEquals((Object)ResolveState.TRANSIENT, (Object)this.adapter.getResolveState());
    }

    @Test
    public void testOid() throws Exception {
        Assert.assertEquals((Object)new TestProxyOid(1, false), (Object)this.oid);
    }

    @Test
    public void test2ndPersistentCreationHasDifferentOid() {
        TestPojo pojo = new TestPojo();
        NakedObject adapter2 = this.system.createTransientTestObject(pojo);
        Assert.assertNotNull((Object)adapter2);
        Assert.assertEquals((Object)new TestProxyOid(2, false), (Object)adapter2.getOid());
    }

    @Test
    public void testIsAddedToObjectLoader() {
        NakedObject a = this.getAdapterManager().getAdapterFor(this.oid);
        Assert.assertEquals((Object)this.adapter, (Object)a);
    }

    @Test
    public void testAddedToPersistor() {
        this.system.resetLoader();
        try {
            this.getPersistenceSession().loadObject(this.oid, this.adapter.getSpecification());
            Assert.fail();
        }
        catch (TestProxyException testProxyException) {
            // empty catch block
        }
    }

    @Test
    public void testNotGivenVersion() throws Exception {
        Assert.assertNull((Object)this.adapter.getVersion());
    }

    @Test
    public void testOidHasNoPrevious() throws Exception {
        Assert.assertNull((Object)this.oid.getPrevious());
    }

    private PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }
}

