/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.NoAuthenticatorException;
import org.nakedobjects.runtime.authentication.standard.Authenticator;
import org.nakedobjects.runtime.authentication.standard.ExplorationSession;
import org.nakedobjects.runtime.authentication.standard.RandomCodeGenerator;
import org.nakedobjects.runtime.authentication.standard.RandomCodeGenerator10Chars;
import org.nakedobjects.runtime.authentication.standard.SimpleSession;
import org.nakedobjects.runtime.context.NakedObjectsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationManagerStandard
implements AuthenticationManager,
DebugInfo {
    private List<Authenticator> authenticators = new ArrayList<Authenticator>();
    private final Map<String, String> users = new HashMap<String, String>();
    private boolean createExploration;
    private RandomCodeGenerator randomCodeGenerator;
    private AuthenticationSession testSession;

    public final void init() {
        this.defaultRandomCodeGeneratorIfNecessary();
        if (this.authenticators.size() == 0) {
            throw new NakedObjectException("No authenticators specified");
        }
    }

    public void shutdown() {
    }

    @Override
    public final AuthenticationSession authenticate(AuthenticationRequest request) {
        if (this.testSession != null) {
            return this.testSession;
        }
        if (this.createExploration) {
            ExplorationSession session = new ExplorationSession();
            return session;
        }
        for (Authenticator authenticator : this.authenticators) {
            if (!authenticator.canAuthenticate(request)) continue;
            SimpleSession user = null;
            if (authenticator.isValid(request)) {
                while (this.users.containsKey((user = this.createSession(request)).getValidationCode())) {
                }
                this.users.put(user.getValidationCode(), user.getUserName());
            }
            return user;
        }
        throw new NoAuthenticatorException("No authenticator available for processing " + request.getClass().getName());
    }

    protected SimpleSession createSession(AuthenticationRequest request) {
        String randomCode = this.randomCodeGenerator.generateRandomCode();
        return new SimpleSession(request.getName(), request.getRoles(), randomCode);
    }

    @Override
    public final boolean isSessionValid(AuthenticationSession session) {
        String userName = this.users.get(session.getValidationCode());
        return userName == null ? false : userName.equals(session.getUserName());
    }

    @Override
    public final void closeSession(AuthenticationSession session) {
        this.users.remove(session.getValidationCode());
        NakedObjectsContext.closeSession();
    }

    public final void addAuthenticator(Authenticator authenticator) {
        this.authenticators.add(authenticator);
    }

    public void setAuthenticators(List<Authenticator> authenticators) {
        this.authenticators = authenticators;
    }

    public void setCreateExploration(boolean createExploration) {
        this.createExploration = createExploration;
    }

    public List<Authenticator> getAuthenticators() {
        return Collections.unmodifiableList(this.authenticators);
    }

    private void defaultRandomCodeGeneratorIfNecessary() {
        if (this.randomCodeGenerator == null) {
            this.randomCodeGenerator = new RandomCodeGenerator10Chars();
        }
    }

    public RandomCodeGenerator getRandomCodeGenerator() {
        return this.randomCodeGenerator;
    }

    public void setRandomCodeGenerator(RandomCodeGenerator randomCodeGenerator) {
        Ensure.ensureThatArg((Object)randomCodeGenerator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"randomCodeGenerator cannot be null");
        this.randomCodeGenerator = randomCodeGenerator;
    }

    public String debugTitle() {
        return "Authentication Manager";
    }

    public void debugData(DebugString debug) {
        debug.appendTitle("Authenticators");
        debug.indent();
        for (Authenticator authenticator : this.authenticators) {
            debug.appendln(authenticator.toString());
        }
        debug.unindent();
        debug.appendTitle("Users");
        debug.indent();
        for (String userName : this.users.values()) {
            debug.appendln(userName);
        }
        debug.unindent();
    }

    public String toString() {
        ToString str = ToString.createAnonymous((Object)this);
        str.append("authenticators", this.authenticators.size());
        str.append("users", this.users.size());
        return str.toString();
    }

    @Override
    public void testSetSession(AuthenticationSession authenticationSession) {
        this.testSession = authenticationSession;
    }
}

